/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.batch.history.HistoricBatch;
import org.operaton.bpm.engine.history.CleanableHistoricBatchReportResult;
import org.operaton.bpm.engine.impl.CleanableHistoricBatchReportImpl;
import org.operaton.bpm.engine.impl.Direction;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.QueryOrderingProperty;
import org.operaton.bpm.engine.impl.QueryPropertyImpl;
import org.operaton.bpm.engine.impl.batch.BatchEntity;
import org.operaton.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.operaton.bpm.engine.impl.batch.history.HistoricBatchQueryImpl;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.ListQueryParameterObject;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.operaton.bpm.engine.impl.history.HistoryLevel;
import org.operaton.bpm.engine.impl.history.event.HistoryEvent;
import org.operaton.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.operaton.bpm.engine.impl.history.event.HistoryEventTypes;
import org.operaton.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.AbstractManager;
import org.operaton.bpm.engine.impl.util.ClockUtil;

public class HistoricBatchManager
extends AbstractManager {
    private static final String MAP = "map";

    public long findBatchCountByQueryCriteria(HistoricBatchQueryImpl historicBatchQuery) {
        this.configureQuery(historicBatchQuery);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricBatchCountByQueryCriteria", historicBatchQuery);
    }

    public List<HistoricBatch> findBatchesByQueryCriteria(HistoricBatchQueryImpl historicBatchQuery, Page page) {
        this.configureQuery(historicBatchQuery);
        return this.getDbEntityManager().selectList("selectHistoricBatchesByQueryCriteria", historicBatchQuery, page);
    }

    public HistoricBatchEntity findHistoricBatchById(String batchId) {
        return this.getDbEntityManager().selectById(HistoricBatchEntity.class, batchId);
    }

    public HistoricBatchEntity findHistoricBatchByJobId(String jobId) {
        return (HistoricBatchEntity)this.getDbEntityManager().selectOne("selectHistoricBatchByJobId", jobId);
    }

    public List<String> findHistoricBatchIdsForCleanup(Integer batchSize, Map<String, Integer> batchOperationsForHistoryCleanup, int minuteFrom, int minuteTo) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("currentTimestamp", ClockUtil.getCurrentTime());
        queryParameters.put(MAP, batchOperationsForHistoryCleanup);
        if (minuteTo - minuteFrom + 1 < 60) {
            queryParameters.put("minuteFrom", minuteFrom);
            queryParameters.put("minuteTo", minuteTo);
        }
        ListQueryParameterObject parameterObject = new ListQueryParameterObject(queryParameters, 0, batchSize);
        parameterObject.getOrderingProperties().add(new QueryOrderingProperty(new QueryPropertyImpl("END_TIME_"), Direction.ASCENDING));
        return this.getDbEntityManager().selectList("selectHistoricBatchIdsForCleanup", parameterObject);
    }

    public void deleteHistoricBatchById(String id) {
        this.getDbEntityManager().delete(HistoricBatchEntity.class, "deleteHistoricBatchById", id);
    }

    public void deleteHistoricBatchesByIds(List<String> historicBatchIds) {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricIncidentManager().deleteHistoricIncidentsByBatchId(historicBatchIds);
        commandContext.getHistoricJobLogManager().deleteHistoricJobLogByBatchIds(historicBatchIds);
        this.getDbEntityManager().deletePreserveOrder(HistoricBatchEntity.class, "deleteHistoricBatchByIds", historicBatchIds);
    }

    public void createHistoricBatch(final BatchEntity batch) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.BATCH_START, batch)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createBatchStartEvent(batch);
                }
            });
        }
    }

    public void completeHistoricBatch(final BatchEntity batch) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.BATCH_END, batch)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createBatchEndEvent(batch);
                }
            });
        }
    }

    public void updateHistoricBatch(final BatchEntity batch) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.BATCH_UPDATE, batch)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createBatchUpdateEvent(batch);
                }
            });
        }
    }

    protected void configureQuery(HistoricBatchQueryImpl query) {
        this.getAuthorizationManager().configureHistoricBatchQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    public List<CleanableHistoricBatchReportResult> findCleanableHistoricBatchesReportByCriteria(CleanableHistoricBatchReportImpl query, Page page, Map<String, Integer> batchOperationsForHistoryCleanup) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        query.setParameter(batchOperationsForHistoryCleanup);
        query.getOrderingProperties().add(new QueryOrderingProperty(new QueryPropertyImpl("TYPE_"), Direction.ASCENDING));
        if (batchOperationsForHistoryCleanup.isEmpty()) {
            return this.getDbEntityManager().selectList("selectOnlyFinishedBatchesReportEntities", query, page);
        }
        return this.getDbEntityManager().selectList("selectFinishedBatchesReportEntities", query, page);
    }

    public long findCleanableHistoricBatchesReportCountByCriteria(CleanableHistoricBatchReportImpl query, Map<String, Integer> batchOperationsForHistoryCleanup) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        query.setParameter(batchOperationsForHistoryCleanup);
        if (batchOperationsForHistoryCleanup.isEmpty()) {
            return (Long)this.getDbEntityManager().selectOne("selectOnlyFinishedBatchesReportEntitiesCount", query);
        }
        return (Long)this.getDbEntityManager().selectOne("selectFinishedBatchesReportEntitiesCount", query);
    }

    public DbOperation deleteHistoricBatchesByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(HistoricBatchEntity.class, "deleteHistoricBatchesByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }

    public void addRemovalTimeById(String id, Date removalTime) {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricIncidentManager().addRemovalTimeToHistoricIncidentsByBatchId(id, removalTime);
        commandContext.getHistoricJobLogManager().addRemovalTimeToJobLogByBatchId(id, removalTime);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", id);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricBatchEntity.class, "updateHistoricBatchRemovalTimeById", parameters);
    }
}

