/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.metrics.util.MetricsUtil;
import org.operaton.bpm.engine.management.MetricIntervalValue;

public class MetricIntervalEntity
implements MetricIntervalValue,
DbEntity,
Serializable {
    protected Date timestamp;
    protected String name;
    protected String reporter;
    protected long value;

    public MetricIntervalEntity(Date timestamp, String name, String reporter) {
        this.timestamp = timestamp;
        this.name = name;
        this.reporter = reporter;
    }

    public MetricIntervalEntity(Long timestamp, String name, String reporter) {
        this.timestamp = new Date(timestamp);
        this.name = name;
        this.reporter = reporter;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = new Date(timestamp);
    }

    @Override
    public String getName() {
        return MetricsUtil.resolvePublicName(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public String getId() {
        return this.name + this.reporter + this.timestamp.toString();
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getPersistentState() {
        return MetricIntervalEntity.class;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        return 67 * hash + (this.reporter != null ? this.reporter.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricIntervalEntity other = (MetricIntervalEntity)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.reporter == null ? other.reporter != null : !this.reporter.equals(other.reporter)) {
            return false;
        }
        return this.timestamp == other.timestamp || this.timestamp != null && this.timestamp.equals(other.timestamp);
    }
}

