/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.operaton.bpm.application.InvocationContext;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.engine.delegate.VariableScope;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.operaton.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.DbEntityLifecycleAware;
import org.operaton.bpm.engine.impl.db.EnginePersistenceLogger;
import org.operaton.bpm.engine.impl.db.HasDbReferences;
import org.operaton.bpm.engine.impl.db.HasDbRevision;
import org.operaton.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.TaskEntity;
import org.operaton.bpm.engine.impl.persistence.entity.util.ByteArrayField;
import org.operaton.bpm.engine.impl.persistence.entity.util.TypedValueField;
import org.operaton.bpm.engine.impl.persistence.entity.util.TypedValueUpdateListener;
import org.operaton.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.operaton.bpm.engine.impl.variable.serializer.ValueFields;
import org.operaton.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import org.operaton.bpm.engine.repository.ResourceTypes;
import org.operaton.bpm.engine.runtime.VariableInstance;
import org.operaton.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.operaton.bpm.engine.variable.type.ValueType;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class VariableInstanceEntity
implements VariableInstance,
CoreVariableInstance,
ValueFields,
DbEntity,
DbEntityLifecycleAware,
TypedValueUpdateListener,
HasDbRevision,
HasDbReferences,
Serializable {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String name;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String executionId;
    protected String taskId;
    protected String batchId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String activityInstanceId;
    protected String tenantId;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected String variableScopeId;
    protected ByteArrayField byteArrayField = new ByteArrayField(this, ResourceTypes.RUNTIME);
    protected TypedValueField typedValueField = new TypedValueField(this, true);
    boolean forcedUpdate;
    protected String configuration;
    protected long sequenceCounter = 1L;
    protected boolean isConcurrentLocal;
    protected boolean isTransient;
    protected ExecutionEntity execution;

    public VariableInstanceEntity() {
        this.typedValueField.addImplicitUpdateListener(this);
    }

    public VariableInstanceEntity(String name, TypedValue value, boolean isTransient) {
        this();
        this.name = name;
        this.isTransient = isTransient;
        this.typedValueField.setValue(value);
    }

    public static VariableInstanceEntity createAndInsert(String name, TypedValue value) {
        VariableInstanceEntity variableInstance = VariableInstanceEntity.create(name, value, value.isTransient());
        VariableInstanceEntity.insert(variableInstance);
        return variableInstance;
    }

    public static void insert(VariableInstanceEntity variableInstance) {
        if (!variableInstance.isTransient()) {
            Context.getCommandContext().getDbEntityManager().insert(variableInstance);
        }
    }

    public static VariableInstanceEntity create(String name, TypedValue value, boolean isTransient) {
        return new VariableInstanceEntity(name, value, isTransient);
    }

    public void delete() {
        if (!this.isTransient()) {
            this.typedValueField.notifyImplicitValueUpdateIfEnabled();
        }
        this.clearValueFields(true);
        if (!this.isTransient) {
            Context.getCommandContext().getDbEntityManager().delete(this);
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        if (this.typedValueField.getSerializerName() != null) {
            persistentState.put("serializerName", this.typedValueField.getSerializerName());
        }
        if (this.longValue != null) {
            persistentState.put("longValue", this.longValue);
        }
        if (this.doubleValue != null) {
            persistentState.put("doubleValue", this.doubleValue);
        }
        if (this.textValue != null) {
            persistentState.put("textValue", this.textValue);
        }
        if (this.textValue2 != null) {
            persistentState.put("textValue2", this.textValue2);
        }
        if (this.byteArrayField.getByteArrayId() != null) {
            persistentState.put("byteArrayValueId", this.byteArrayField.getByteArrayId());
        }
        persistentState.put("sequenceCounter", this.getSequenceCounter());
        persistentState.put("concurrentLocal", this.isConcurrentLocal);
        persistentState.put("executionId", this.executionId);
        persistentState.put("taskId", this.taskId);
        persistentState.put("caseExecutionId", this.caseExecutionId);
        persistentState.put("caseInstanceId", this.caseInstanceId);
        persistentState.put("tenantId", this.tenantId);
        persistentState.put("processInstanceId", this.processInstanceId);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    public void setCaseExecution(CaseExecutionEntity caseExecution) {
        if (caseExecution != null) {
            this.caseInstanceId = caseExecution.getCaseInstanceId();
            this.caseExecutionId = caseExecution.getId();
            this.tenantId = caseExecution.getTenantId();
        } else {
            this.caseInstanceId = null;
            this.caseExecutionId = null;
            this.tenantId = null;
        }
    }

    public String getByteArrayValueId() {
        return this.byteArrayField.getByteArrayId();
    }

    public void setByteArrayValueId(String byteArrayValueId) {
        this.byteArrayField.setByteArrayId(byteArrayValueId);
    }

    @Override
    public byte[] getByteArrayValue() {
        return this.byteArrayField.getByteArrayValue();
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        this.byteArrayField.setByteArrayValue(bytes, this.isTransient);
    }

    protected void deleteByteArrayValue() {
        this.byteArrayField.deleteByteArrayValue();
    }

    @Override
    public Object getValue() {
        return this.typedValueField.getValue();
    }

    @Override
    public TypedValue getTypedValue() {
        return this.typedValueField.getTypedValue(this.isTransient);
    }

    @Override
    public TypedValue getTypedValue(boolean deserializeValue) {
        return this.typedValueField.getTypedValue(deserializeValue, this.isTransient);
    }

    @Override
    public void setValue(TypedValue value) {
        String oldTypeAsString;
        Object newValue = value;
        ValueType newType = null;
        if (newValue instanceof UntypedValueImpl) {
            UntypedValueImpl impl = (UntypedValueImpl)newValue;
            newValue = TypedValueField.getSerializers().findSerializerForValue((TypedValue)newValue, this.getFallbackSerializerFactory()).convertToTypedValue(impl);
            newType = newValue.getType();
        }
        this.clearValueFields(!this.isObjectTyped(newType, oldTypeAsString = this.typedValueField.getTypeName()));
        this.typedValueField.setValue((TypedValue)newValue);
    }

    protected boolean isObjectTyped(ValueType newType, String oldTypeAsString) {
        return ValueType.OBJECT.equals(newType) && newType.getName().equals(oldTypeAsString);
    }

    protected VariableSerializerFactory getFallbackSerializerFactory() {
        return Context.getProcessEngineConfiguration().getFallbackSerializerFactory();
    }

    public void clearValueFields(boolean deleteVariable) {
        this.longValue = null;
        this.doubleValue = null;
        this.textValue = null;
        this.textValue2 = null;
        this.typedValueField.clear();
        if (deleteVariable && this.byteArrayField.getByteArrayId() != null) {
            this.deleteByteArrayValue();
            this.setByteArrayValueId(null);
        }
    }

    @Override
    public String getTypeName() {
        return this.typedValueField.getTypeName();
    }

    @Override
    public void postLoad() {
        this.typedValueField.postLoad();
    }

    protected void ensureExecutionInitialized() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
    }

    public ExecutionEntity getExecution() {
        this.ensureExecutionInitialized();
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
        if (execution == null) {
            this.executionId = null;
            this.processInstanceId = null;
            this.processDefinitionId = null;
            this.tenantId = null;
        } else {
            this.setExecutionId(execution.getId());
            this.processDefinitionId = execution.getProcessDefinitionId();
            this.processInstanceId = execution.getProcessInstanceId();
            this.tenantId = execution.getTenantId();
        }
    }

    public CaseExecutionEntity getCaseExecution() {
        if (this.caseExecutionId != null) {
            return Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.caseExecutionId);
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setSerializer(TypedValueSerializer<?> serializer) {
        this.typedValueField.setSerializerName(serializer.getName());
    }

    public void setSerializerName(String type) {
        this.typedValueField.setSerializerName(type);
    }

    public TypedValueSerializer<?> getSerializer() {
        return this.typedValueField.getSerializer();
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public void setTask(TaskEntity task) {
        if (task != null) {
            this.taskId = task.getId();
            this.tenantId = task.getTenantId();
            if (task.getExecution() != null) {
                this.setExecution(task.getExecution());
            }
            if (task.getCaseExecution() != null) {
                this.setCaseExecution(task.getCaseExecution());
            }
        } else {
            this.taskId = null;
            this.tenantId = null;
            this.setExecution(null);
            this.setCaseExecution(null);
        }
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public String getSerializerName() {
        return this.typedValueField.getSerializerName();
    }

    @Override
    public String getErrorMessage() {
        return this.typedValueField.getErrorMessage();
    }

    public String getVariableScopeId() {
        if (this.variableScopeId != null) {
            return this.variableScopeId;
        }
        if (this.taskId != null) {
            return this.taskId;
        }
        if (this.executionId != null) {
            return this.executionId;
        }
        return this.caseExecutionId;
    }

    public void setVariableScopeId(String variableScopeId) {
        this.variableScopeId = variableScopeId;
    }

    protected VariableScope getVariableScope() {
        if (this.taskId != null) {
            return this.getTask();
        }
        if (this.executionId != null) {
            return this.getExecution();
        }
        if (this.caseExecutionId != null) {
            return this.getCaseExecution();
        }
        return null;
    }

    protected TaskEntity getTask() {
        if (this.taskId != null) {
            return Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        }
        return null;
    }

    public long getSequenceCounter() {
        return this.sequenceCounter;
    }

    public void setSequenceCounter(long sequenceCounter) {
        this.sequenceCounter = sequenceCounter;
    }

    public void incrementSequenceCounter() {
        ++this.sequenceCounter;
    }

    public boolean isConcurrentLocal() {
        return this.isConcurrentLocal;
    }

    public void setConcurrentLocal(boolean isConcurrentLocal) {
        this.isConcurrentLocal = isConcurrentLocal;
    }

    @Override
    public void onImplicitValueUpdate(TypedValue updatedValue) {
        ProcessApplicationReference targetProcessApplication = this.getContextProcessApplication();
        if (targetProcessApplication != null) {
            Context.executeWithinProcessApplication(() -> {
                this.getVariableScope().setVariableLocal(this.name, updatedValue);
                return null;
            }, targetProcessApplication, new InvocationContext(this.getExecution()));
        } else if (!this.isTransient) {
            this.getVariableScope().setVariableLocal(this.name, updatedValue);
        }
    }

    protected ProcessApplicationReference getContextProcessApplication() {
        if (this.taskId != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(this.getTask());
        }
        if (this.executionId != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(this.getExecution());
        }
        if (this.caseExecutionId != null) {
            return ProcessApplicationContextUtil.getTargetProcessApplication(this.getCaseExecution());
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", name=" + this.name + ", processDefinitionId=" + this.processDefinitionId + ", processInstanceId=" + this.processInstanceId + ", executionId=" + this.executionId + ", caseInstanceId=" + this.caseInstanceId + ", caseExecutionId=" + this.caseExecutionId + ", taskId=" + this.taskId + ", activityInstanceId=" + this.activityInstanceId + ", tenantId=" + this.tenantId + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", textValue=" + this.textValue + ", textValue2=" + this.textValue2 + ", byteArrayValueId=" + this.getByteArrayValueId() + ", configuration=" + this.configuration + ", isConcurrentLocal=" + this.isConcurrentLocal + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + (this.id == null ? 0 : this.id.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableInstanceEntity other = (VariableInstanceEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        return new HashSet<String>();
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        if (this.processInstanceId != null) {
            referenceIdAndClass.put(this.processInstanceId, ExecutionEntity.class);
        }
        if (this.executionId != null) {
            referenceIdAndClass.put(this.executionId, ExecutionEntity.class);
        }
        if (this.caseInstanceId != null) {
            referenceIdAndClass.put(this.caseInstanceId, CaseExecutionEntity.class);
        }
        if (this.caseExecutionId != null) {
            referenceIdAndClass.put(this.caseExecutionId, CaseExecutionEntity.class);
        }
        if (this.getByteArrayValueId() != null) {
            referenceIdAndClass.put(this.getByteArrayValueId(), ByteArrayEntity.class);
        }
        return referenceIdAndClass;
    }

    public boolean wasCreatedBefore713() {
        return this.getProcessDefinitionId() == null;
    }
}

