/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.pvm.runtime;

public interface ActivityInstanceState {
    public static final ActivityInstanceState DEFAULT = new ActivityInstanceStateImpl(0, "default");
    public static final ActivityInstanceState SCOPE_COMPLETE = new ActivityInstanceStateImpl(1, "scopeComplete");
    public static final ActivityInstanceState CANCELED = new ActivityInstanceStateImpl(2, "canceled");
    public static final ActivityInstanceState STARTING = new ActivityInstanceStateImpl(3, "starting");
    public static final ActivityInstanceState ENDING = new ActivityInstanceStateImpl(4, "ending");

    public int getStateCode();

    public static class ActivityInstanceStateImpl
    implements ActivityInstanceState {
        public final int stateCode;
        protected final String name;

        public ActivityInstanceStateImpl(int suspensionCode, String string) {
            this.stateCode = suspensionCode;
            this.name = string;
        }

        @Override
        public int getStateCode() {
            return this.stateCode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            return 31 * result + this.stateCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActivityInstanceStateImpl other = (ActivityInstanceStateImpl)obj;
            return this.stateCode == other.stateCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

