/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.pvm.runtime.operation;

import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.pvm.PvmException;
import org.operaton.bpm.engine.impl.pvm.PvmLogger;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.operaton.bpm.engine.impl.util.ActivityBehaviorUtil;

public class PvmAtomicOperationActivityExecute
implements PvmAtomicOperation {
    private static final PvmLogger LOG = ProcessEngineLogger.PVM_LOGGER;

    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return false;
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        execution.activityInstanceStarted();
        execution.continueIfExecutionDoesNotAffectNextOperation(execution1 -> {
            if (execution1.getActivity().isScope()) {
                execution1.dispatchEvent(null);
            }
            return null;
        }, execution2 -> {
            ActivityBehavior activityBehavior = ActivityBehaviorUtil.getActivityBehavior(execution2);
            ActivityImpl activity = execution2.getActivity();
            LOG.debugExecutesActivity((PvmExecutionImpl)execution2, activity, activityBehavior.getClass().getName());
            try {
                activityBehavior.execute((ActivityExecution)execution2);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PvmException("couldn't execute activity <" + String.valueOf(activity.getProperty("type")) + " id=\"" + activity.getId() + "\" ...>: " + e.getMessage(), e);
            }
            return null;
        }, execution);
    }

    @Override
    public String getCanonicalName() {
        return "activity-execute";
    }

    @Override
    public boolean isAsyncCapable() {
        return false;
    }
}

