/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.task.listener;

import java.util.List;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.delegate.DelegateTask;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.delegate.ProcessEngineServicesAware;
import org.operaton.bpm.engine.delegate.TaskListener;
import org.operaton.bpm.engine.delegate.VariableScope;
import org.operaton.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.task.delegate.TaskListenerInvocation;
import org.operaton.bpm.engine.impl.util.ClassDelegateUtil;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionTaskListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        ProcessEngineServicesAware variableScope = delegateTask.getExecution();
        if (variableScope == null) {
            variableScope = delegateTask.getCaseExecution();
        }
        Object delegate = this.expression.getValue((VariableScope)((Object)variableScope));
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (delegate instanceof TaskListener) {
            TaskListener taskListener = (TaskListener)delegate;
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(taskListener, delegateTask));
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
        } else {
            throw new ProcessEngineException("Delegate expression " + String.valueOf(this.expression) + " did not resolve to an implementation of " + String.valueOf(TaskListener.class));
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }

    public List<FieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }
}

