/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.operaton.bpm.engine.impl.tree.TreeVisitor;

public abstract class ReferenceWalker<T> {
    protected List<T> currentElements;
    protected List<TreeVisitor<T>> preVisitor = new ArrayList<TreeVisitor<T>>();
    protected List<TreeVisitor<T>> postVisitor = new ArrayList<TreeVisitor<T>>();

    protected abstract Collection<T> nextElements();

    protected ReferenceWalker(T initialElement) {
        this.currentElements = new LinkedList<T>();
        this.currentElements.add(initialElement);
    }

    protected ReferenceWalker(List<T> initialElements) {
        this.currentElements = new LinkedList<T>(initialElements);
    }

    public ReferenceWalker<T> addPreVisitor(TreeVisitor<T> collector) {
        this.preVisitor.add(collector);
        return this;
    }

    public ReferenceWalker<T> addPostVisitor(TreeVisitor<T> collector) {
        this.postVisitor.add(collector);
        return this;
    }

    public T walkWhile() {
        return (T)this.walkWhile(new NullCondition());
    }

    public T walkUntil() {
        return (T)this.walkUntil(new NullCondition());
    }

    public T walkWhile(WalkCondition<T> condition) {
        while (!condition.isFulfilled(this.getCurrentElement())) {
            for (TreeVisitor<T> collector : this.preVisitor) {
                collector.visit(this.getCurrentElement());
            }
            this.currentElements.addAll(this.nextElements());
            this.currentElements.remove(0);
            for (TreeVisitor<T> collector : this.postVisitor) {
                collector.visit(this.getCurrentElement());
            }
        }
        return this.getCurrentElement();
    }

    public T walkUntil(WalkCondition<T> condition) {
        do {
            for (TreeVisitor<T> collector : this.preVisitor) {
                collector.visit(this.getCurrentElement());
            }
            this.currentElements.addAll(this.nextElements());
            this.currentElements.remove(0);
            for (TreeVisitor<T> collector : this.postVisitor) {
                collector.visit(this.getCurrentElement());
            }
        } while (!condition.isFulfilled(this.getCurrentElement()));
        return this.getCurrentElement();
    }

    public T getCurrentElement() {
        return this.currentElements.isEmpty() ? null : (T)this.currentElements.get(0);
    }

    public static class NullCondition<S>
    implements WalkCondition<S> {
        @Override
        public boolean isFulfilled(S element) {
            return element == null;
        }

        public static <S> WalkCondition<S> notNull() {
            return new NullCondition<S>();
        }
    }

    public static interface WalkCondition<S> {
        public boolean isFulfilled(S var1);
    }
}

