/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.util.EngineUtilLogger;

public final class BitMaskUtil {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    private static final int FLAG_BIT_1 = 1;
    private static final int FLAG_BIT_2 = 2;
    private static final int FLAG_BIT_3 = 4;
    private static final int FLAG_BIT_4 = 8;
    private static final int FLAG_BIT_5 = 16;
    private static final int FLAG_BIT_6 = 32;
    private static final int FLAG_BIT_7 = 64;
    private static final int FLAG_BIT_8 = 128;
    private static final int[] MASKS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};

    private BitMaskUtil() {
    }

    public static int setBitOn(int value, int bitNumber) {
        BitMaskUtil.ensureBitRange(bitNumber);
        return value | MASKS[bitNumber - 1];
    }

    public static int setBitOff(int value, int bitNumber) {
        BitMaskUtil.ensureBitRange(bitNumber);
        return value & ~MASKS[bitNumber - 1];
    }

    public static boolean isBitOn(int value, int bitNumber) {
        BitMaskUtil.ensureBitRange(bitNumber);
        return (value & MASKS[bitNumber - 1]) == MASKS[bitNumber - 1];
    }

    public static int setBit(int value, int bitNumber, boolean bitValue) {
        if (bitValue) {
            return BitMaskUtil.setBitOn(value, bitNumber);
        }
        return BitMaskUtil.setBitOff(value, bitNumber);
    }

    public static int getMaskForBit(int bitNumber) {
        return MASKS[bitNumber - 1];
    }

    static void ensureBitRange(int bitNumber) {
        if (bitNumber <= 0 || bitNumber > 8) {
            throw LOG.invalidBitNumber(bitNumber);
        }
    }
}

