/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.parser.FailedJobRetryConfiguration;
import org.operaton.bpm.engine.impl.calendar.DurationHelper;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.el.Expression;
import org.operaton.bpm.engine.impl.el.ExpressionManager;
import org.operaton.bpm.engine.impl.telemetry.dto.JdkImpl;
import org.operaton.bpm.engine.impl.util.EngineUtilLogger;
import org.operaton.bpm.engine.impl.util.ProcessEngineDetails;
import org.operaton.bpm.engine.impl.util.ProductPropertiesUtil;
import org.operaton.bpm.engine.impl.util.StringUtil;

public final class ParseUtil {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    protected static final Pattern REGEX_TTL_ISO = Pattern.compile("^P(\\d+)D$");

    private ParseUtil() {
    }

    public static Integer parseHistoryTimeToLive(String historyTimeToLive) {
        Integer timeToLive = null;
        if (historyTimeToLive != null && !historyTimeToLive.isEmpty()) {
            Matcher matISO = REGEX_TTL_ISO.matcher(historyTimeToLive);
            if (matISO.find()) {
                historyTimeToLive = matISO.group(1);
            }
            timeToLive = ParseUtil.parseIntegerAttribute("historyTimeToLive", historyTimeToLive);
        }
        if (timeToLive != null && timeToLive < 0) {
            throw new NotValidException("Cannot parse historyTimeToLive: negative value is not allowed");
        }
        return timeToLive;
    }

    protected static Integer parseIntegerAttribute(String attributeName, String text) {
        Integer result = null;
        if (text != null && !text.isEmpty()) {
            try {
                result = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                throw new ProcessEngineException("Cannot parse " + attributeName + ": " + e.getMessage());
            }
        }
        return result;
    }

    public static FailedJobRetryConfiguration parseRetryIntervals(String retryIntervals) {
        if (retryIntervals != null && !retryIntervals.isEmpty()) {
            if (StringUtil.isExpression(retryIntervals)) {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                Expression expression = expressionManager.createExpression(retryIntervals);
                return new FailedJobRetryConfiguration(expression);
            }
            String[] intervals = StringUtil.split(retryIntervals, ",");
            int retries = intervals.length + 1;
            if (intervals.length == 1) {
                try {
                    DurationHelper durationHelper = new DurationHelper(intervals[0]);
                    if (durationHelper.isRepeat()) {
                        retries = durationHelper.getTimes();
                    }
                }
                catch (Exception e) {
                    LOG.logParsingRetryIntervals(intervals[0], e);
                    return null;
                }
            }
            return new FailedJobRetryConfiguration(retries, Arrays.asList(intervals));
        }
        return null;
    }

    public static ProcessEngineDetails parseProcessEngineVersion(boolean trimSuffixEE) {
        String version = ProductPropertiesUtil.getProductVersion();
        return ParseUtil.parseProcessEngineVersion(version, trimSuffixEE);
    }

    public static ProcessEngineDetails parseProcessEngineVersion(String version, boolean trimSuffixEE) {
        String edition = "community";
        if (version.contains("-ee")) {
            edition = "enterprise";
            if (trimSuffixEE) {
                version = version.replace("-ee", "");
            }
        }
        return new ProcessEngineDetails(version, edition);
    }

    public static String parseServerVendor(String applicationServerInfo) {
        String serverVendor = "";
        Pattern pattern = Pattern.compile("[\\sA-Za-z]+");
        Matcher matcher = pattern.matcher(applicationServerInfo);
        if (matcher.find()) {
            try {
                serverVendor = matcher.group();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            serverVendor = serverVendor.trim();
            if (serverVendor.contains("WildFly")) {
                return "WildFly";
            }
        }
        return serverVendor;
    }

    public static JdkImpl parseJdkDetails() {
        String jdkVendor = System.getProperty("java.vm.vendor");
        if (jdkVendor != null && jdkVendor.contains("Oracle") && System.getProperty("java.vm.name").contains("OpenJDK")) {
            jdkVendor = "OpenJDK";
        }
        String jdkVersion = System.getProperty("java.version");
        return new JdkImpl(jdkVersion, jdkVendor);
    }
}

