/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.variable.serializer;

import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.variable.serializer.AbstractSerializableValueSerializer;
import org.operaton.bpm.engine.impl.variable.serializer.ValueFields;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.operaton.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.operaton.bpm.engine.variable.type.ValueType;
import org.operaton.bpm.engine.variable.value.ObjectValue;

public abstract class AbstractObjectValueSerializer
extends AbstractSerializableValueSerializer<ObjectValue> {
    protected AbstractObjectValueSerializer(String serializationDataFormat) {
        super(ValueType.OBJECT, serializationDataFormat);
    }

    @Override
    public ObjectValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return (ObjectValue)Variables.objectValue((Object)untypedValue.getValue(), (boolean)untypedValue.isTransient()).create();
    }

    @Override
    protected void writeToValueFields(ObjectValue value, ValueFields valueFields, byte[] serializedValue) {
        String objectTypeName = this.getObjectTypeName(value, valueFields);
        valueFields.setByteArrayValue(serializedValue);
        valueFields.setTextValue2(objectTypeName);
    }

    protected String getObjectTypeName(ObjectValue value, ValueFields valueFields) {
        String objectTypeName = value.getObjectTypeName();
        if (objectTypeName == null && !value.isDeserialized() && value.getValueSerialized() != null) {
            throw new ProcessEngineException("Cannot write serialized value for variable '" + valueFields.getName() + "': no 'objectTypeName' provided for non-null value.");
        }
        if (value.isDeserialized() && value.getValue() != null) {
            objectTypeName = this.getTypeNameForDeserialized(value.getValue());
        }
        return objectTypeName;
    }

    @Override
    protected void updateTypedValue(ObjectValue value, String serializedStringValue) {
        String objectTypeName = this.getObjectTypeName(value, null);
        ObjectValueImpl objectValue = (ObjectValueImpl)value;
        objectValue.setObjectTypeName(objectTypeName);
        objectValue.setSerializedValue(serializedStringValue);
        objectValue.setSerializationDataFormat(this.serializationDataFormat);
    }

    @Override
    protected ObjectValue createDeserializedValue(Object deserializedObject, String serializedStringValue, ValueFields valueFields, boolean asTransientValue) {
        String objectTypeName = this.readObjectNameFromFields(valueFields);
        ObjectValueImpl objectValue = new ObjectValueImpl(deserializedObject, serializedStringValue, this.serializationDataFormat, objectTypeName, true);
        objectValue.setTransient(asTransientValue);
        return objectValue;
    }

    @Override
    protected ObjectValue createSerializedValue(String serializedStringValue, ValueFields valueFields, boolean asTransientValue) {
        String objectTypeName = this.readObjectNameFromFields(valueFields);
        ObjectValueImpl objectValue = new ObjectValueImpl(null, serializedStringValue, this.serializationDataFormat, objectTypeName, false);
        objectValue.setTransient(asTransientValue);
        return objectValue;
    }

    protected String readObjectNameFromFields(ValueFields valueFields) {
        return valueFields.getTextValue2();
    }

    @Override
    public boolean isMutableValue(ObjectValue typedValue) {
        return typedValue.isDeserialized();
    }

    protected abstract String getTypeNameForDeserialized(Object var1);

    @Override
    protected abstract byte[] serializeToByteArray(Object var1) throws Exception;

    @Override
    protected Object deserializeFromByteArray(byte[] object, ValueFields valueFields) throws Exception {
        String objectTypeName = this.readObjectNameFromFields(valueFields);
        return this.deserializeFromByteArray(object, objectTypeName);
    }

    protected abstract Object deserializeFromByteArray(byte[] var1, String var2) throws Exception;

    @Override
    protected abstract boolean isSerializationTextBased();
}

