/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter;

import jakarta.servlet.ServletContext;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.operaton.bpm.application.PostDeploy;
import org.operaton.bpm.application.PreUndeploy;
import org.operaton.bpm.container.RuntimeContainerDelegate;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.spring.application.SpringProcessApplication;
import org.operaton.bpm.spring.boot.starter.configuration.OperatonDeploymentConfiguration;
import org.operaton.bpm.spring.boot.starter.event.PostDeployEvent;
import org.operaton.bpm.spring.boot.starter.event.PreUndeployEvent;
import org.operaton.bpm.spring.boot.starter.property.OperatonBpmProperties;
import org.operaton.bpm.spring.boot.starter.util.GetProcessApplicationNameFromAnnotation;
import org.operaton.bpm.spring.boot.starter.util.SpringBootProcessEngineLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;

@Configuration
public class SpringBootProcessApplication
extends SpringProcessApplication {
    @Value(value="${spring.application.name:null}")
    protected Optional<String> springApplicationName;
    protected String contextPath = "/";
    protected OperatonBpmProperties operatonBpmProperties;
    protected ProcessEngine processEngine;
    protected ApplicationEventPublisher eventPublisher;

    @Bean
    public static OperatonDeploymentConfiguration deploymentConfiguration() {
        return new OperatonDeploymentConfiguration(){

            @Override
            public Set<Resource> getDeploymentResources() {
                return Collections.emptySet();
            }

            @Override
            public void preInit(ProcessEngineConfigurationImpl configuration) {
                SpringBootProcessEngineLogger.LOG.skipAutoDeployment();
            }

            public String toString() {
                return "disableDeploymentResourcePattern";
            }
        };
    }

    @Autowired
    public SpringBootProcessApplication(OperatonBpmProperties operatonBpmProperties, ProcessEngine processEngine, ApplicationEventPublisher eventPublisher) {
        this.operatonBpmProperties = operatonBpmProperties;
        this.processEngine = processEngine;
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() {
        GetProcessApplicationNameFromAnnotation.processApplicationNameFromAnnotation(this.applicationContext).apply(this.springApplicationName).ifPresent(arg_0 -> ((SpringBootProcessApplication)this).setBeanName(arg_0));
        if (this.operatonBpmProperties.getGenerateUniqueProcessApplicationName().booleanValue()) {
            this.setBeanName(OperatonBpmProperties.getUniqueName("processApplication"));
        }
        String processEngineName = this.processEngine.getName();
        this.setDefaultDeployToEngineName(processEngineName);
        RuntimeContainerDelegate.INSTANCE.get().registerProcessEngine(this.processEngine);
        this.properties.put("servletContextPath", this.contextPath);
        super.afterPropertiesSet();
    }

    public void destroy() {
        super.destroy();
        RuntimeContainerDelegate.INSTANCE.get().unregisterProcessEngine(this.processEngine);
    }

    @PostDeploy
    public void onPostDeploy(ProcessEngine processEngine) {
        this.eventPublisher.publishEvent((Object)new PostDeployEvent(processEngine));
    }

    @PreUndeploy
    public void onPreUndeploy(ProcessEngine processEngine) {
        this.eventPublisher.publishEvent((Object)new PreUndeployEvent(processEngine));
    }

    @ConditionalOnWebApplication
    @Configuration
    class WebApplicationConfiguration
    implements ServletContextAware {
        WebApplicationConfiguration() {
        }

        public void setServletContext(ServletContext servletContext) {
            if (!StringUtils.isEmpty((Object)servletContext.getContextPath())) {
                SpringBootProcessApplication.this.contextPath = servletContext.getContextPath();
            }
        }
    }
}

