/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter.configuration.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.operaton.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.operaton.bpm.spring.boot.starter.configuration.OperatonDeploymentConfiguration;
import org.operaton.bpm.spring.boot.starter.configuration.impl.AbstractOperatonConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;

public class DefaultDeploymentConfiguration
extends AbstractOperatonConfiguration
implements OperatonDeploymentConfiguration {
    private final Logger LOGGER = LoggerFactory.getLogger(DefaultDeploymentConfiguration.class);

    @Override
    public void preInit(SpringProcessEngineConfiguration configuration) {
        if (this.operatonBpmProperties.isAutoDeploymentEnabled()) {
            Set<Resource> resources = this.getDeploymentResources();
            configuration.setDeploymentResources(resources.toArray(new Resource[resources.size()]));
            LOG.autoDeployResources(resources);
        }
    }

    @Override
    public Set<Resource> getDeploymentResources() {
        ResourceArrayPropertyEditor resolver = new ResourceArrayPropertyEditor();
        try {
            String[] resourcePattern = this.operatonBpmProperties.getDeploymentResourcePattern();
            this.LOGGER.debug("resolving deployment resources for pattern {}", (Object[])resourcePattern);
            resolver.setValue((Object)resourcePattern);
            return Arrays.stream((Resource[])resolver.getValue()).peek(resource -> this.LOGGER.debug("processing deployment resource {}", resource)).filter(this::isFile).peek(resource -> this.LOGGER.debug("added deployment resource {}", resource)).collect(Collectors.toSet());
        }
        catch (RuntimeException e) {
            this.LOGGER.error("unable to resolve resources", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private boolean isFile(Resource resource) {
        if (resource.isReadable()) {
            if (resource instanceof UrlResource || resource instanceof ClassPathResource) {
                try {
                    URL url = resource.getURL();
                    return !url.toString().endsWith("/");
                }
                catch (IOException e) {
                    this.LOGGER.debug("unable to handle " + String.valueOf(resource) + " as URL", (Throwable)e);
                }
            } else {
                try {
                    return !resource.getFile().isDirectory();
                }
                catch (IOException e) {
                    this.LOGGER.debug("unable to handle " + String.valueOf(resource) + " as file", (Throwable)e);
                }
            }
        }
        this.LOGGER.warn("unable to determine if resource {} is a deployable resource", (Object)resource);
        return false;
    }
}

