/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.springframework.util.CollectionUtils;

public final class OperatonSpringBootUtil {
    public static <T> Optional<T> cast(Object obj, Class<T> type) {
        return Optional.ofNullable(obj).filter(type::isInstance).map(type::cast);
    }

    public static SpringProcessEngineConfiguration springProcessEngineConfiguration() {
        return OperatonSpringBootUtil.initCustomFields(new SpringProcessEngineConfiguration());
    }

    public static Optional<ProcessEngineImpl> processEngineImpl(ProcessEngine processEngine) {
        return OperatonSpringBootUtil.cast(processEngine, ProcessEngineImpl.class);
    }

    public static Optional<SpringProcessEngineConfiguration> springProcessEngineConfiguration(ProcessEngineConfiguration configuration) {
        return OperatonSpringBootUtil.cast(configuration, SpringProcessEngineConfiguration.class);
    }

    public static SpringProcessEngineConfiguration get(ProcessEngine processEngine) {
        return (SpringProcessEngineConfiguration)processEngine.getProcessEngineConfiguration();
    }

    public static <T> List<T> join(List<? extends T> existing, List<? extends T> add) {
        ArrayList<Object> target = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty(existing)) {
            target.addAll(existing);
        }
        if (!CollectionUtils.isEmpty(add)) {
            target.addAll(add);
        }
        return target;
    }

    public static SpringProcessEngineConfiguration initCustomFields(SpringProcessEngineConfiguration configuration) {
        if (configuration.getCustomPostCommandInterceptorsTxRequired() == null) {
            configuration.setCustomPostCommandInterceptorsTxRequired(new ArrayList());
        }
        if (configuration.getCustomPreCommandInterceptorsTxRequired() == null) {
            configuration.setCustomPreCommandInterceptorsTxRequired(new ArrayList());
        }
        if (configuration.getCustomPreCommandInterceptorsTxRequiresNew() == null) {
            configuration.setCustomPreCommandInterceptorsTxRequiresNew(new ArrayList());
        }
        if (configuration.getCustomPostCommandInterceptorsTxRequiresNew() == null) {
            configuration.setCustomPostCommandInterceptorsTxRequiresNew(new ArrayList());
        }
        if (configuration.getCustomSessionFactories() == null) {
            configuration.setCustomSessionFactories(new ArrayList());
        }
        if (configuration.getCustomPreDeployers() == null) {
            configuration.setCustomPreDeployers(new ArrayList());
        }
        if (configuration.getCustomPostDeployers() == null) {
            configuration.setCustomPostDeployers(new ArrayList());
        }
        if (configuration.getCustomJobHandlers() == null) {
            configuration.setCustomJobHandlers(new ArrayList());
        }
        if (configuration.getCustomIncidentHandlers() == null) {
            configuration.setCustomIncidentHandlers(new ArrayList());
        }
        if (configuration.getCustomBatchJobHandlers() == null) {
            configuration.setCustomBatchJobHandlers(new ArrayList());
        }
        if (configuration.getCustomFormEngines() == null) {
            configuration.setCustomFormEngines(new ArrayList());
        }
        if (configuration.getCustomFormFieldValidators() == null) {
            configuration.setCustomFormFieldValidators(new HashMap());
        }
        if (configuration.getCustomFormTypes() == null) {
            configuration.setCustomFormTypes(new ArrayList());
        }
        if (configuration.getCustomPreVariableSerializers() == null) {
            configuration.setCustomPreVariableSerializers(new ArrayList());
        }
        if (configuration.getCustomPostVariableSerializers() == null) {
            configuration.setCustomPostVariableSerializers(new ArrayList());
        }
        if (configuration.getCustomHistoryLevels() == null) {
            configuration.setCustomHistoryLevels(new ArrayList());
        }
        if (configuration.getCustomPreCmmnTransformListeners() == null) {
            configuration.setCustomPreCmmnTransformListeners(new ArrayList());
        }
        if (configuration.getCustomPostCmmnTransformListeners() == null) {
            configuration.setCustomPostCmmnTransformListeners(new ArrayList());
        }
        if (configuration.getCustomPreBPMNParseListeners() == null) {
            configuration.setCustomPreBPMNParseListeners(new ArrayList());
        }
        if (configuration.getCustomPostBPMNParseListeners() == null) {
            configuration.setCustomPostBPMNParseListeners(new ArrayList());
        }
        if (configuration.getCustomEventHandlers() == null) {
            configuration.setCustomEventHandlers(new ArrayList());
        }
        if (configuration.getCustomPreMigrationActivityValidators() == null) {
            configuration.setCustomPreMigrationActivityValidators(new ArrayList());
        }
        if (configuration.getCustomPostMigrationActivityValidators() == null) {
            configuration.setCustomPostMigrationActivityValidators(new ArrayList());
        }
        if (configuration.getCustomPreMigrationInstructionValidators() == null) {
            configuration.setCustomPreMigrationInstructionValidators(new ArrayList());
        }
        if (configuration.getCustomPostMigrationInstructionValidators() == null) {
            configuration.setCustomPostMigrationInstructionValidators(new ArrayList());
        }
        if (configuration.getCustomPreMigratingActivityInstanceValidators() == null) {
            configuration.setCustomPreMigratingActivityInstanceValidators(new ArrayList());
        }
        if (configuration.getCustomPostMigratingActivityInstanceValidators() == null) {
            configuration.setCustomPostMigratingActivityInstanceValidators(new ArrayList());
        }
        return configuration;
    }

    private OperatonSpringBootUtil() {
    }
}

