/*
 * Copyright 2006 Niclas Hedhman.
 *
 * Licensed  under the  Apache License,  Version 2.0  (the "License");
 * you may not use  this file  except in  compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed  under the  License is distributed on an "AS IS" BASIS,
 * WITHOUT  WARRANTIES OR CONDITIONS  OF ANY KIND, either  express  or
 * implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ops4j.monitors.exception;

/**
 * A monitor of a Exceptions occuring.
 *
 * @author <a href="http://www.ops4j.org">Open Particpation Software for Java</a>
 * @version $Id: StreamMonitor.java 3757 2006-03-23 12:43:08Z niclas@hedhman.org $
 */
public interface ExceptionMonitor
{

    /**
     * This method is called when an Exception or Throwable occurs.
     *
     * @param source    The source of the exception. That is the class that is throwing the exception.
     * @param exception The Exception being thrown.
     */
    void exception( ExceptionSource source, Throwable exception );
}

