/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.inherit;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.ops4j.pax.construct.inherit.PluginXml;

public class InheritMojo
extends AbstractMojo {
    private static final String GOAL = "goal";
    private static final String EXTENDS_PLUGIN = "extendsPlugin";
    private static final String EXTENDS_GOAL = "extendsGoal";
    private MavenProject m_project;
    private File m_outputDirectory;
    private ArchiverManager m_archiverManager;

    public void execute() throws MojoExecutionException {
        PluginXml targetPlugin = this.loadPluginMetadata(this.m_outputDirectory);
        Map dependentPluginsByName = this.loadDependentPluginMetaData();
        JavaDocBuilder builder = new JavaDocBuilder();
        Iterator i = this.m_project.getCompileSourceRoots().iterator();
        while (i.hasNext()) {
            builder.addSourceTree(new File((String)i.next()));
        }
        JavaSource[] javaSources = builder.getSources();
        for (int i2 = 0; i2 < javaSources.length; ++i2) {
            JavaClass mojoClass = javaSources[i2].getClasses()[0];
            DocletTag extendsTag = mojoClass.getTagByName(EXTENDS_PLUGIN);
            if (null == extendsTag) continue;
            String pluginName = extendsTag.getValue();
            this.getLog().info((CharSequence)("Extending " + pluginName + " plugin"));
            PluginXml superPlugin = (PluginXml)dependentPluginsByName.get(pluginName);
            if (null == superPlugin) {
                throw new MojoExecutionException(pluginName + " plugin is not a dependency");
            }
            this.mergePluginMojo(mojoClass, targetPlugin, superPlugin);
        }
        try {
            targetPlugin.write();
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot update local plugin metadata", (Exception)e);
        }
    }

    private PluginXml loadPluginMetadata(File pluginDir) throws MojoExecutionException {
        File metadata = new File(pluginDir, "META-INF/maven/plugin.xml");
        try {
            return new PluginXml(metadata);
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot read plugin metadata " + metadata, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("cannot parse plugin metadata " + metadata, (Exception)((Object)e));
        }
    }

    private Map loadDependentPluginMetaData() throws MojoExecutionException {
        File buildArea = new File(this.m_project.getBuild().getDirectory(), "plugins");
        HashMap<String, PluginXml> pluginsByName = new HashMap<String, PluginXml>();
        Iterator i = this.m_project.getDependencyArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (!"maven-plugin".equals(artifact.getType()) || artifact.getFile() == null) continue;
            File unpackDir = new File(buildArea, artifact.getArtifactId());
            this.unpackPlugin(artifact, unpackDir);
            String name = artifact.getArtifactId().replaceAll("(?:maven-)?(\\w+)(?:-maven)?-plugin", "$1");
            PluginXml pluginXml = this.loadPluginMetadata(unpackDir);
            pluginsByName.put(artifact.getArtifactId(), pluginXml);
            pluginsByName.put(name, pluginXml);
        }
        return pluginsByName;
    }

    private void unpackPlugin(Artifact artifact, File unpackDir) throws MojoExecutionException {
        File pluginFile = artifact.getFile();
        unpackDir.mkdirs();
        try {
            UnArchiver unArchiver = this.m_archiverManager.getUnArchiver(pluginFile);
            unArchiver.setDestDirectory(unpackDir);
            unArchiver.setSourceFile(pluginFile);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("cannot find unarchiver for " + pluginFile, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("problem reading file " + pluginFile, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("problem unpacking file " + pluginFile, (Exception)((Object)e));
        }
    }

    private void mergePluginMojo(JavaClass mojoClass, PluginXml targetPlugin, PluginXml superPlugin) throws MojoExecutionException {
        DocletTag goalTag = mojoClass.getTagByName(GOAL);
        if (null == goalTag) {
            return;
        }
        DocletTag superGoalTag = mojoClass.getTagByName(EXTENDS_GOAL);
        if (null == superGoalTag) {
            superGoalTag = goalTag;
        }
        String goal = goalTag.getValue();
        String superGoal = superGoalTag.getValue();
        this.getLog().info((CharSequence)(superGoal + " => " + goal));
        Xpp3Dom targetMojoXml = targetPlugin.findMojo(goal);
        Xpp3Dom superMojoXml = superPlugin.findMojo(superGoal);
        if (null == superMojoXml) {
            throw new MojoExecutionException("cannot find " + superGoal + " goal in " + superPlugin);
        }
        PluginXml.mergeMojo(targetMojoXml, superMojoXml);
    }
}

