/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.inherit;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.ops4j.pax.construct.inherit.PluginSerializer;
import org.ops4j.pax.construct.inherit.StreamFactory;

public class PluginXml {
    private static final String EXECUTE_GOAL = "executeGoal";
    private static final String EXECUTE_PHASE = "executePhase";
    private final File m_file;
    private Xpp3Dom m_xml;

    public PluginXml(File file) throws XmlPullParserException, IOException {
        this.m_file = file;
        MXParser parser = new MXParser();
        Reader reader = StreamFactory.newXmlReader(this.m_file);
        parser.setInput(reader);
        this.m_xml = Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)false);
        IOUtil.close((Reader)reader);
    }

    public String toString() {
        return this.m_xml.getChild("artifactId").getValue();
    }

    public Xpp3Dom[] getMojos() {
        return this.m_xml.getChild("mojos").getChildren("mojo");
    }

    public Xpp3Dom findMojo(String goal) {
        Xpp3Dom[] mojos = this.getMojos();
        for (int i = 0; i < mojos.length; ++i) {
            if (!goal.equals(mojos[i].getChild("goal").getValue())) continue;
            return mojos[i];
        }
        return null;
    }

    public static void mergeMojo(Xpp3Dom mojo, Xpp3Dom superMojo) {
        Xpp3Dom tempMojo = new Xpp3Dom(superMojo);
        PluginXml.removeDuplicates(mojo, tempMojo, "parameters", "name/", true);
        PluginXml.removeDuplicates(mojo, tempMojo, "configuration", null, false);
        PluginXml.removeDuplicates(mojo, tempMojo, "requirements", "field-name/", true);
        PluginXml.removeDuplicateExecuteTags(mojo, tempMojo);
        PluginXml.setAppendMode(mojo.getChild("parameters"));
        PluginXml.setAppendMode(mojo.getChild("configuration"));
        PluginXml.setAppendMode(mojo.getChild("requirements"));
        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mojo, (Xpp3Dom)tempMojo);
    }

    private static void removeDuplicates(Xpp3Dom mojo, Xpp3Dom tempMojo, String name, String path, boolean verbose) {
        Xpp3Dom list = mojo.getChild(name);
        Xpp3Dom tempList = tempMojo.getChild(name);
        if (null == tempList || null == list) {
            return;
        }
        for (int s = 0; s < tempList.getChildCount(); ++s) {
            Xpp3Dom idElement = PluginXml.getIdElement(tempList.getChild(s), path);
            if (!PluginXml.hasMatchingElement(list, path, verbose, idElement)) continue;
            tempList.removeChild(s--);
        }
    }

    private static boolean hasMatchingElement(Xpp3Dom list, String path, boolean verbose, Xpp3Dom theIdElement) {
        for (int n = 0; n < list.getChildCount(); ++n) {
            String rhs;
            String lhs;
            Xpp3Dom idElement = PluginXml.getIdElement(list.getChild(n), path);
            if (null != path && path.endsWith("/")) {
                lhs = theIdElement.getValue();
                rhs = idElement.getValue();
            } else {
                lhs = theIdElement.getName();
                rhs = idElement.getName();
            }
            if (!lhs.equals(rhs)) continue;
            if (verbose) {
                System.out.println("[WARN] overriding field " + lhs);
            }
            return true;
        }
        return false;
    }

    private static Xpp3Dom getIdElement(Xpp3Dom element, String path) {
        Xpp3Dom idElement = element;
        if (null != path) {
            String[] idSegments = path.split("/");
            for (int i = 0; i < idSegments.length; ++i) {
                idElement = element.getChild(idSegments[i]);
            }
        }
        return idElement;
    }

    private static void removeDuplicateExecuteTags(Xpp3Dom mojo, Xpp3Dom tempMojo) {
        Xpp3Dom executeNode = mojo.getChild(EXECUTE_PHASE);
        if (null == executeNode) {
            executeNode = mojo.getChild(EXECUTE_GOAL);
        }
        if (executeNode != null) {
            PluginXml.removeChild(tempMojo, tempMojo.getChild(EXECUTE_PHASE));
            PluginXml.removeChild(tempMojo, tempMojo.getChild(EXECUTE_GOAL));
            if ("none".equals(executeNode.getValue())) {
                PluginXml.removeChild(mojo, executeNode);
            }
        }
    }

    private static boolean removeChild(Xpp3Dom xml, Xpp3Dom child) {
        for (int i = xml.getChildCount() - 1; i >= 0; --i) {
            if (xml.getChild(i) != child) continue;
            xml.removeChild(i);
            return true;
        }
        return false;
    }

    private static void setAppendMode(Xpp3Dom element) {
        if (null != element) {
            element.setAttribute("combine.children", "append");
        }
    }

    public void write() throws IOException {
        String encoding = StreamFactory.getXmlEncoding(this.m_file);
        Writer writer = StreamFactory.newXmlWriter(this.m_file);
        PluginSerializer serializer = new PluginSerializer();
        serializer.setOutput(writer);
        serializer.startDocument(encoding, null);
        this.m_xml.writeToSerializer(null, (XmlSerializer)serializer);
        serializer.endDocument();
        IOUtil.close((Writer)writer);
    }
}

