/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.inherit;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

final class StreamFactory {
    private StreamFactory() {
    }

    public static Reader newXmlReader(File xmlFile) throws IOException {
        try {
            return XmlStreamFactory.newXmlReader(xmlFile);
        }
        catch (NoClassDefFoundError e) {
            return new FileReader(xmlFile);
        }
    }

    public static Writer newXmlWriter(File xmlFile) throws IOException {
        try {
            return XmlStreamFactory.newXmlWriter(xmlFile);
        }
        catch (NoClassDefFoundError e) {
            return new FileWriter(xmlFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXmlEncoding(File xmlFile) {
        Reader reader = null;
        try {
            reader = StreamFactory.newXmlReader(xmlFile);
            String string = ((XmlStreamReader)reader).getEncoding();
            return string;
        }
        catch (IOException e) {
            String string = System.getProperty("file.encoding");
            return string;
        }
        catch (NoClassDefFoundError e) {
            String string = System.getProperty("file.encoding");
            return string;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private static final class XmlStreamFactory {
        private XmlStreamFactory() {
        }

        static Reader newXmlReader(File xmlFile) throws IOException {
            return ReaderFactory.newXmlReader((File)xmlFile);
        }

        static Writer newXmlWriter(File xmlFile) throws IOException {
            return WriterFactory.newXmlWriter((File)xmlFile);
        }
    }
}

