/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.bundle;

import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.ops4j.pax.construct.bundle.MoveBundleMojo;
import org.ops4j.pax.construct.util.PomIterator;
import org.ops4j.pax.construct.util.PomUtils;

public class RemoveBundleMojo
extends AbstractMojo {
    private File baseDirectory;
    private String bundleName;
    private boolean repair;

    public void execute() throws MojoExecutionException {
        PomUtils.Pom bundlePom = MoveBundleMojo.locateBundlePom(this.baseDirectory, this.bundleName);
        if ("pom".equals(bundlePom.getPackaging())) {
            throw new MojoExecutionException("Ignoring multi-module project " + this.bundleName);
        }
        if (this.repair) {
            PomIterator i = new PomIterator(this.baseDirectory);
            while (i.hasNext()) {
                PomUtils.Pom pom = (PomUtils.Pom)i.next();
                if (pom.equals(bundlePom)) continue;
                this.removeBundleReferences(pom, bundlePom);
            }
        }
        this.dropBundleOwnership(bundlePom);
        this.removeBundleFiles(bundlePom);
    }

    private void dropBundleOwnership(PomUtils.Pom bundlePom) {
        String moduleName = bundlePom.getBasedir().getName();
        try {
            PomUtils.Pom modulesPom = bundlePom.getContainingPom();
            if (null != modulesPom) {
                modulesPom.removeModule(moduleName);
                modulesPom.write();
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Module " + moduleName + " not found in containing POM"));
        }
    }

    private void removeBundleFiles(PomUtils.Pom bundlePom) {
        this.getLog().info((CharSequence)("Removing " + bundlePom));
        File bundleDir = bundlePom.getBasedir();
        try {
            FileUtils.deleteDirectory((File)bundleDir);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to remove directory " + bundleDir), (Throwable)e);
        }
    }

    private void removeBundleReferences(PomUtils.Pom pom, PomUtils.Pom bundlePom) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(bundlePom.getGroupId());
        dependency.setArtifactId(bundlePom.getArtifactId());
        if (pom.removeDependency(dependency)) {
            this.getLog().info((CharSequence)("Removing " + bundlePom + " from " + pom));
            try {
                pom.write();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Problem writing Maven POM: " + pom.getFile()));
            }
        }
    }
}

