/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.project;

import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.ops4j.pax.construct.util.PomUtils;

public class AddRepositoryMojo
extends AbstractMojo {
    private String repositoryId;
    private String repositoryURL;
    private File targetDirectory;
    private boolean overwrite;
    private boolean snapshots;
    private boolean releases;
    private boolean pluginRepo;

    public void execute() throws MojoExecutionException {
        PomUtils.Pom pom;
        try {
            pom = PomUtils.readPom(this.targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot execute command. It requires a project with an existing pom.xml, but the build is not using one.");
        }
        Repository repository = new Repository();
        repository.setId(this.repositoryId);
        repository.setUrl(this.repositoryURL);
        if (this.pluginRepo) {
            this.getLog().info((CharSequence)("Adding plugin repository " + this.repositoryURL + " to " + pom));
        } else {
            this.getLog().info((CharSequence)("Adding repository " + this.repositoryURL + " to " + pom));
        }
        pom.addRepository(repository, this.snapshots, this.releases, this.overwrite, this.pluginRepo);
        try {
            pom.write();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Problem writing Maven POM: " + pom.getFile());
        }
    }
}

