/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.ExcludeSystemBundlesFilter;
import org.ops4j.pax.construct.util.PomUtils;

public class ImportBundleMojo
extends AbstractMojo {
    private ArtifactFactory m_factory;
    private ArtifactResolver m_resolver;
    private ArtifactMetadataSource m_source;
    private MavenProjectBuilder m_projectBuilder;
    private List m_remoteRepos;
    private ArtifactRepository m_localRepo;
    private String groupId;
    private String artifactId;
    private String version;
    private String exclusions;
    private String provisionId;
    private File targetDirectory;
    private boolean importTransitive;
    private boolean importOptional;
    private boolean widenScope;
    private boolean testMetadata;
    private boolean deploy;
    private boolean overwrite;
    private PomUtils.Pom m_provisionPom;
    private PomUtils.Pom m_localBundlePom;
    private List m_candidateIds;
    private Set m_visitedIds;

    public void execute() throws MojoExecutionException {
        this.populateMissingFields();
        this.m_provisionPom = DirUtils.findPom(this.targetDirectory, this.provisionId);
        this.m_localBundlePom = ImportBundleMojo.readBundlePom(this.targetDirectory);
        if (null == this.m_provisionPom && null == this.m_localBundlePom) {
            throw new MojoExecutionException("Cannot execute command. It requires a project with an existing pom.xml, but the build is not using one.");
        }
        String rootId = this.groupId + ':' + this.artifactId + ':' + this.version;
        this.m_candidateIds = new ArrayList();
        this.m_visitedIds = new HashSet();
        this.excludeCandidates(this.exclusions);
        this.scheduleCandidate(rootId);
        this.importBundles(rootId);
        this.writeUpdatedPom(this.m_localBundlePom);
        this.writeUpdatedPom(this.m_provisionPom);
    }

    private void importBundles(String rootId) {
        while (!this.m_candidateIds.isEmpty()) {
            String id = (String)this.m_candidateIds.remove(0);
            String[] fields = id.split(":");
            MavenProject p = this.buildMavenProject(fields[0], fields[1], fields[2]);
            if (null == p) continue;
            if ("pom".equals(p.getPackaging())) {
                this.processDependencies(p);
                continue;
            }
            if (rootId.equals(id) || PomUtils.isBundleProject(p, this.m_resolver, this.m_remoteRepos, this.m_localRepo, this.testMetadata)) {
                this.importBundle(p);
                if (!this.importTransitive) break;
                this.processDependencies(p);
                continue;
            }
            this.getLog().info((CharSequence)("Ignoring non-bundle dependency " + p.getId()));
        }
    }

    private void populateMissingFields() throws MojoExecutionException {
        if (PomUtils.isEmpty(this.groupId)) {
            PomUtils.Pom localPom = DirUtils.findPom(this.targetDirectory, this.artifactId);
            if (localPom != null) {
                this.groupId = localPom.getGroupId();
                if (PomUtils.needReleaseVersion(this.version)) {
                    this.version = localPom.getVersion();
                }
            } else {
                this.groupId = this.artifactId;
            }
        }
        if (PomUtils.needReleaseVersion(this.version)) {
            Artifact artifact = this.m_factory.createBuildArtifact(this.groupId, this.artifactId, "RELEASE", "jar");
            this.version = PomUtils.getReleaseVersion(artifact, this.m_source, this.m_remoteRepos, this.m_localRepo, null);
        }
    }

    private void writeUpdatedPom(PomUtils.Pom pom) {
        if (pom != null) {
            try {
                pom.write();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to update " + pom));
            }
        }
    }

    private static PomUtils.Pom readBundlePom(File here) {
        try {
            PomUtils.Pom bundlePom = PomUtils.readPom(here);
            if (null != bundlePom && bundlePom.isBundleProject()) {
                return bundlePom;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private MavenProject buildMavenProject(String pomGroupId, String pomArtifactId, String pomVersion) {
        DistributionManagement dm;
        MavenProject project;
        Artifact pomArtifact = this.m_factory.createProjectArtifact(pomGroupId, pomArtifactId, pomVersion);
        try {
            project = this.m_projectBuilder.buildFromRepository(pomArtifact, this.m_remoteRepos, this.m_localRepo);
        }
        catch (ProjectBuildingException e) {
            this.getLog().warn((CharSequence)("Problem resolving project " + pomArtifact.getId()));
            return null;
        }
        PomUtils.Pom localPom = DirUtils.findPom(this.targetDirectory, pomGroupId + ':' + pomArtifactId);
        if (localPom != null) {
            project.setFile(localPom.getFile());
        }
        if ((dm = project.getDistributionManagement()) != null && "generated".equals(dm.getStatus())) {
            if (localPom != null) {
                project.setPackaging(localPom.getPackaging());
                project.setName(localPom.getId());
            } else {
                Artifact jar = this.m_factory.createBuildArtifact(pomGroupId, pomArtifactId, pomVersion, "jar");
                project.setArtifact(jar);
                project.setPackaging("jar");
                project.setName(jar.getId());
            }
        }
        return project;
    }

    private void processDependencies(MavenProject project) {
        try {
            Set artifacts = project.createArtifacts(this.m_factory, null, (ArtifactFilter)new ExcludeSystemBundlesFilter());
            Iterator i = artifacts.iterator();
            while (i.hasNext()) {
                Artifact artifact = (Artifact)i.next();
                String candidateId = ImportBundleMojo.getCandidateId(artifact);
                String scope = artifact.getScope();
                scope = this.adjustDependencyScope(scope);
                if (!this.importOptional && artifact.isOptional()) {
                    this.getLog().info((CharSequence)("Skipping optional dependency " + artifact));
                    continue;
                }
                if ("provided".equals(scope)) {
                    this.scheduleCandidate(candidateId);
                    continue;
                }
                this.getLog().info((CharSequence)("Skipping dependency " + artifact));
            }
        }
        catch (InvalidDependencyVersionException e) {
            this.getLog().warn((CharSequence)("Problem resolving dependencies for " + project.getId()));
        }
    }

    private void scheduleCandidate(String candidateId) {
        int versionIndex = candidateId.lastIndexOf(58);
        if (this.m_visitedIds.add(candidateId.substring(0, versionIndex))) {
            this.m_candidateIds.add(candidateId);
        }
    }

    private String adjustDependencyScope(String scope) {
        if (this.widenScope && !"system".equals(scope) && !"test".equals(scope)) {
            return "provided";
        }
        return scope;
    }

    private static String getCandidateId(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + PomUtils.getMetaVersion(artifact);
    }

    private void importBundle(MavenProject project) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(project.getGroupId());
        dependency.setArtifactId(project.getArtifactId());
        dependency.setVersion(project.getVersion());
        dependency.setOptional(!this.deploy);
        if (this.m_provisionPom != null && project.getFile() == null) {
            this.getLog().info((CharSequence)("Importing " + project.getName() + " to " + this.m_provisionPom));
            this.m_provisionPom.addDependency(dependency, this.overwrite);
        }
        if (this.m_localBundlePom != null) {
            dependency.setScope("provided");
            this.getLog().info((CharSequence)("Adding " + project.getName() + " as dependency to " + this.m_localBundlePom));
            this.m_localBundlePom.addDependency(dependency, this.overwrite);
        }
    }

    private void excludeCandidates(String artifacts) {
        if (PomUtils.isEmpty(artifacts)) {
            return;
        }
        String[] exclusionIds = artifacts.split(",");
        for (int i = 0; i < exclusionIds.length; ++i) {
            String id = exclusionIds[i].trim();
            String[] fields = id.split(":");
            if (fields.length > 1) {
                this.m_visitedIds.add(fields[0] + ':' + fields[1]);
                continue;
            }
            this.m_visitedIds.add(id + ':' + id);
        }
    }
}

