/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.lifecycle;

import [Ljava.lang.String;;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.IOUtil;
import org.ops4j.pax.construct.util.PomUtils;
import org.ops4j.pax.construct.util.StreamFactory;

public class ProvisionMojo
extends AbstractMojo {
    private static final String PAX_RUNNER_GROUP = "org.ops4j.pax.runner";
    private static final String PAX_RUNNER_ARTIFACT = "pax-runner";
    private static final String PAX_RUNNER_METHOD = "org.ops4j.pax.runner.Run";
    private static List m_bundleIds;
    private ArtifactMetadataSource m_source;
    private ArtifactFactory m_factory;
    private ArtifactResolver m_resolver;
    private ArtifactInstaller m_installer;
    private MavenProjectBuilder m_projectBuilder;
    private Settings m_settings;
    private List m_remoteRepos;
    private ArtifactRepository m_localRepo;
    private MavenProject m_project;
    private List m_reactorProjects;
    private String framework;
    private boolean deploy;
    private String profiles;
    private String args;
    private boolean noDependencies;
    private String deployPoms;
    private String deployURLs;
    private String runner;
    private String[] provision;
    private ArtifactRepositoryFactory m_repoFactory;
    private ArtifactRepositoryLayout m_defaultLayout;
    private WagonManager m_wagonManager;
    private Method m_getMirrorRepository;

    public void execute() throws MojoExecutionException {
        m_bundleIds = new ArrayList();
        if (this.deployPoms != null) {
            this.addAdditionalPoms();
        }
        if (this.m_project.getFile() != null) {
            Iterator i = this.m_reactorProjects.iterator();
            while (i.hasNext()) {
                this.addProjectBundles((MavenProject)i.next(), false == this.noDependencies);
            }
        }
        this.setupRuntimeHelpers();
        this.deployBundles();
    }

    private void setupRuntimeHelpers() {
        try {
            this.m_getMirrorRepository = this.m_wagonManager.getClass().getMethod("getMirrorRepository", ArtifactRepository.class);
        }
        catch (RuntimeException e) {
            this.m_getMirrorRepository = null;
        }
        catch (NoSuchMethodException e) {
            this.m_getMirrorRepository = null;
        }
    }

    public static boolean isProvisioningPom(MavenProject project) {
        if (!"provision".equals(project.getArtifactId())) {
            return false;
        }
        if (!"pom".equals(project.getPackaging())) {
            return false;
        }
        List dependencies = project.getDependencies();
        return dependencies != null && dependencies.size() != 0;
    }

    private void addProjectBundles(MavenProject project, boolean checkDependencies) {
        if (PomUtils.isBundleProject(project, this.m_resolver, this.m_remoteRepos, this.m_localRepo, true)) {
            this.provisionBundle(project.getArtifact());
        }
        if (checkDependencies || ProvisionMojo.isProvisioningPom(project)) {
            this.addProjectDependencies(project);
        }
    }

    private void addProjectDependencies(MavenProject project) {
        Set artifacts = project.getArtifacts();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (artifact.isOptional() || "test".equals(artifact.getScope())) continue;
            this.provisionBundle(artifact);
        }
    }

    private void provisionBundle(Artifact bundle) {
        if ("pom".equals(bundle.getType())) {
            return;
        }
        if (!PomUtils.downloadFile(bundle, this.m_resolver, this.m_remoteRepos, this.m_localRepo)) {
            this.getLog().warn((CharSequence)("Skipping missing artifact " + bundle));
            return;
        }
        if (PomUtils.isBundleArtifact(bundle, this.m_resolver, this.m_remoteRepos, this.m_localRepo, true)) {
            String version = PomUtils.getMetaVersion(bundle);
            String id = bundle.getGroupId() + ':' + bundle.getArtifactId() + ':' + version + ':' + bundle.getType();
            if (!m_bundleIds.contains(id)) {
                m_bundleIds.add(id);
            }
        } else {
            this.getLog().warn((CharSequence)("Skipping non-bundle artifact " + bundle));
        }
    }

    private void addAdditionalPoms() {
        String[] pomPaths = this.deployPoms.split(",");
        for (int i = 0; i < pomPaths.length; ++i) {
            File pomFile = new File(pomPaths[i].trim());
            if (!pomFile.exists()) continue;
            try {
                this.addProjectBundles(this.m_projectBuilder.build(pomFile, this.m_localRepo, null), true);
                continue;
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Unable to build Maven project for " + pomFile));
            }
        }
    }

    private void deployBundles() throws MojoExecutionException {
        Class clazz;
        Pattern classicVersion;
        if (m_bundleIds.size() == 0) {
            this.getLog().info((CharSequence)"~~~~~~~~~~~~~~~~~~~");
            this.getLog().info((CharSequence)" No bundles found! ");
            this.getLog().info((CharSequence)"~~~~~~~~~~~~~~~~~~~");
        }
        List bundles = this.resolveProvisionedBundles();
        MavenProject deployProject = this.createDeploymentProject(bundles);
        this.installDeploymentPom(deployProject);
        if (!this.deploy) {
            this.getLog().info((CharSequence)"Skipping OSGi deployment");
            return;
        }
        this.m_remoteRepos.add(this.getOps4jRepository());
        String delim = "";
        StringBuffer repoListBuilder = new StringBuffer("+");
        Iterator i = this.m_remoteRepos.iterator();
        while (i.hasNext()) {
            repoListBuilder.append(delim);
            ArtifactRepository repo = (ArtifactRepository)i.next();
            repoListBuilder.append(this.getRepositoryURL(repo));
            if (repo.getSnapshots().isEnabled()) {
                repoListBuilder.append("@snapshots");
            }
            if (!repo.getReleases().isEnabled()) {
                repoListBuilder.append("@noreleases");
            }
            delim = ",";
        }
        if (PomUtils.needReleaseVersion(this.runner)) {
            Artifact runnerProject = this.m_factory.createProjectArtifact(PAX_RUNNER_GROUP, PAX_RUNNER_ARTIFACT, this.runner);
            this.runner = PomUtils.getReleaseVersion(runnerProject, this.m_source, this.m_remoteRepos, this.m_localRepo, null);
        }
        if ((classicVersion = Pattern.compile("0\\.[1-4]\\.\\d")).matcher(this.runner).matches()) {
            clazz = this.loadRunnerClass("org.ops4j.pax", "runner", PAX_RUNNER_METHOD, false);
            this.deployRunnerClassic(clazz, deployProject, repoListBuilder.toString());
        } else {
            clazz = this.loadRunnerClass(PAX_RUNNER_GROUP, PAX_RUNNER_ARTIFACT, PAX_RUNNER_METHOD, true);
            this.deployRunnerNG(clazz, deployProject, repoListBuilder.toString());
        }
    }

    private String getRepositoryURL(ArtifactRepository repo) {
        Mirror mirror;
        if (null != this.m_getMirrorRepository) {
            try {
                mirror = (ArtifactRepository)this.m_getMirrorRepository.invoke((Object)this.m_wagonManager, repo);
                if (null != mirror) {
                    return mirror.getUrl();
                }
            }
            catch (RuntimeException e) {
                this.getLog().warn((Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.getLog().warn((Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.getLog().warn((Throwable)e);
            }
        }
        if (null != (mirror = this.m_settings.getMirrorOf(repo.getId()))) {
            return mirror.getUrl();
        }
        mirror = this.m_settings.getMirrorOf("*");
        if (null != mirror) {
            return mirror.getUrl();
        }
        return repo.getUrl();
    }

    private List resolveProvisionedBundles() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Iterator i = m_bundleIds.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            String[] fields = id.split(":");
            Dependency dep = new Dependency();
            dep.setGroupId(fields[0]);
            dep.setArtifactId(fields[1]);
            dep.setVersion(fields[2]);
            dep.setType(fields[3]);
            dep.setScope("provided");
            dependencies.add(dep);
        }
        return dependencies;
    }

    private MavenProject createDeploymentProject(List bundles) throws MojoExecutionException {
        MavenProject deployProject;
        if (null == this.m_project.getFile()) {
            deployProject = new MavenProject();
            deployProject.setGroupId("examples");
            deployProject.setArtifactId("pax-provision");
            deployProject.setVersion("1.0-SNAPSHOT");
        } else {
            deployProject = new MavenProject(this.m_project);
        }
        String internalId = PomUtils.getCompoundId(deployProject.getGroupId(), deployProject.getArtifactId());
        deployProject.setGroupId(internalId + ".build");
        deployProject.setArtifactId("deployment");
        deployProject.setPackaging("pom");
        deployProject.getModel().setModules(null);
        deployProject.getModel().setDependencies(bundles);
        deployProject.getModel().setPluginRepositories(null);
        deployProject.getModel().setReporting(null);
        deployProject.setBuild(null);
        File deployFile = new File(deployProject.getBasedir(), "runner/deploy-pom.xml");
        deployFile.getParentFile().mkdirs();
        deployProject.setFile(deployFile);
        try {
            Writer writer = StreamFactory.newXmlWriter(deployFile);
            deployProject.writeModel(writer);
            IOUtil.close((Writer)writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write deployment POM " + deployFile);
        }
        return deployProject;
    }

    private void installDeploymentPom(MavenProject project) throws MojoExecutionException {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        Artifact pomArtifact = this.m_factory.createProjectArtifact(groupId, artifactId, version);
        try {
            this.m_installer.install(project.getFile(), pomArtifact, this.m_localRepo);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Unable to install deployment POM " + pomArtifact);
        }
    }

    private Class loadRunnerClass(String groupId, String artifactId, String mainClass, boolean needClassifier) throws MojoExecutionException {
        Artifact jarArtifact;
        String jdk = null;
        if (needClassifier && System.getProperty("java.class.version").compareTo("49.0") < 0) {
            jdk = "jdk14";
        }
        if (!PomUtils.downloadFile(jarArtifact = this.m_factory.createArtifactWithClassifier(groupId, artifactId, this.runner, "jar", jdk), this.m_resolver, this.m_remoteRepos, this.m_localRepo)) {
            throw new MojoExecutionException("Unable to find Pax-Runner " + jarArtifact);
        }
        URL[] urls = new URL[1];
        try {
            urls[0] = jarArtifact.getFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Bad Jar location " + jarArtifact.getFile());
        }
        try {
            URLClassLoader loader = new URLClassLoader(urls);
            Thread.currentThread().setContextClassLoader(loader);
            return Class.forName(mainClass, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to find entry point " + mainClass + " in " + urls[0]);
        }
    }

    private void deployRunnerClassic(Class mainClass, MavenProject project, String repositories) throws MojoExecutionException {
        String workDir = project.getBasedir() + "/runner";
        String cachedPomName = project.getArtifactId() + '_' + project.getVersion() + ".pom";
        File cachedPomFile = new File(workDir + "/lib/" + cachedPomName);
        cachedPomFile.delete();
        if (PomUtils.isEmpty(this.framework)) {
            this.framework = "felix";
        }
        String[] deployAppCmds = new String[]{"--dir=" + workDir, "--no-md5", "--platform=" + this.framework, "--profile=default", "--repository=" + repositories, "--localRepository=" + this.m_localRepo.getBasedir(), project.getGroupId(), project.getArtifactId(), project.getVersion()};
        this.invokePaxRunner(mainClass, deployAppCmds);
    }

    protected List getDeployCommands() {
        return new ArrayList();
    }

    private void deployRunnerNG(Class mainClass, MavenProject project, String repositories) throws MojoExecutionException {
        List deployAppCmds = this.getDeployCommands();
        if (PomUtils.isNotEmpty(this.framework)) {
            deployAppCmds.add("--platform=" + this.framework);
        }
        if (PomUtils.isNotEmpty(this.profiles)) {
            deployAppCmds.add("--profiles=" + this.profiles);
        }
        if (PomUtils.isNotEmpty(this.args)) {
            try {
                new URL(this.args);
            }
            catch (MalformedURLException e) {
                File argsFile = new File(this.args);
                this.args = argsFile.toURI().toString();
            }
            deployAppCmds.add("--args=" + this.args);
        }
        deployAppCmds.addAll(Arrays.asList(this.provision));
        deployAppCmds.add(project.getFile().getAbsolutePath());
        if (PomUtils.isNotEmpty(this.deployURLs)) {
            String[] urls = this.deployURLs.split(",");
            for (int i = 0; i < urls.length; ++i) {
                deployAppCmds.add(urls[i].trim());
            }
        }
        deployAppCmds.add("--localRepository=" + this.m_localRepo.getBasedir());
        deployAppCmds.add("--repositories=" + repositories);
        deployAppCmds.add("--overwriteUserBundles");
        this.getLog().debug((CharSequence)("Starting Pax-Runner " + this.runner + " with: " + deployAppCmds.toString()));
        this.invokePaxRunner(mainClass, deployAppCmds.toArray(new String[deployAppCmds.size()]));
    }

    private void invokePaxRunner(Class mainClass, String[] commands) throws MojoExecutionException {
        Class[] paramTypes = new Class[]{String;.class};
        Object[] paramValues = new Object[]{commands};
        try {
            Method entryPoint = mainClass.getMethod("main", paramTypes);
            entryPoint.invoke(null, paramValues);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("Unable to find Pax-Runner entry point");
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to access Pax-Runner entry point");
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Pax-Runner exception", (Exception)e);
        }
    }

    ArtifactRepository getOps4jRepository() {
        ArtifactRepositoryPolicy noSnapshots = new ArtifactRepositoryPolicy(false, "daily", null);
        ArtifactRepositoryPolicy releases = new ArtifactRepositoryPolicy(true, "never", null);
        return this.m_repoFactory.createArtifactRepository("ops4j.releases", "http://repository.ops4j.org/maven2/", this.m_defaultLayout, noSnapshots, releases);
    }
}

