/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;

public final class ReflectMojo {
    private final AbstractMojo m_mojo;
    private final Class m_clazz;

    public ReflectMojo(AbstractMojo mojo, Class clazz) {
        this.m_mojo = mojo;
        this.m_clazz = clazz;
    }

    Field getMojoField(String name) throws NoSuchFieldException {
        return this.m_clazz.getDeclaredField(name);
    }

    AbstractMojo getMojoInstance() {
        return this.m_mojo;
    }

    Log getMojoLogger() {
        return this.m_mojo.getLog();
    }

    public boolean hasField(final String name) {
        return null != AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return ReflectMojo.this.getMojoField(name);
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
    }

    public void setField(final String name, final Object value) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Field f = ReflectMojo.this.getMojoField(name);
                    Object safeValue = Boolean.TYPE.equals(f.getType()) ? Boolean.valueOf(value.toString()) : value;
                    f.setAccessible(true);
                    f.set(ReflectMojo.this.getMojoInstance(), safeValue);
                }
                catch (NoSuchFieldException e) {
                    ReflectMojo.this.getMojoLogger().error((CharSequence)("Unknown field " + name), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    ReflectMojo.this.getMojoLogger().error((CharSequence)("Cannot set field " + name), (Throwable)e);
                }
                return null;
            }
        });
    }

    public Object getField(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Field f = ReflectMojo.this.getMojoField(name);
                    f.setAccessible(true);
                    return f.get(ReflectMojo.this.getMojoInstance());
                }
                catch (NoSuchFieldException e) {
                    ReflectMojo.this.getMojoLogger().error((CharSequence)("Unknown field " + name), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    ReflectMojo.this.getMojoLogger().error((CharSequence)("Cannot get field " + name), (Throwable)e);
                }
                return null;
            }
        });
    }
}

