/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.cm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.cm.ConfigurationOption;
import org.ops4j.pax.exam.cm.internal.ConfigurationOptionActivator;
import org.ops4j.pax.exam.cm.internal.ConfigurationOptionConfigurationListener;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.UrlProvisionOption;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;

public class ConfigurationProvisionOption
implements ConfigurationOption {
    private final String id;
    private final Map<String, Object> properties;
    private boolean create = true;
    private boolean override;
    private boolean factory;

    public ConfigurationProvisionOption(String id, Map<String, Object> properties) {
        this.id = id;
        this.properties = properties;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ConfigurationOption put(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public ConfigurationOption putAll(Map<String, ?> _properties) {
        this.properties.putAll(_properties);
        return this;
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.properties;
    }

    @Override
    public ConfigurationOption create(boolean _create) {
        this.create = _create;
        return this;
    }

    @Override
    public ConfigurationOption override(boolean _override) {
        this.override = _override;
        return this;
    }

    @Override
    public ConfigurationOption factory(boolean _factory) {
        this.factory = _factory;
        return this;
    }

    @Override
    public boolean isCreate() {
        return this.create;
    }

    @Override
    public boolean isOverride() {
        return this.override;
    }

    @Override
    public boolean isFactory() {
        return this.factory;
    }

    public ProvisionOption<?> asOption() {
        return ConfigurationProvisionOption.createProvisionOption(this);
    }

    private static ProvisionOption<?> createProvisionOption(ConfigurationOption configOption) {
        ObjectOutputStream os;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            os = new ObjectOutputStream(outputStream);
        }
        catch (IOException e) {
            throw new TestContainerException("can't write stream headers", (Throwable)e);
        }
        String id = configOption.getId();
        if (id == null) {
            throw new TestContainerException("ConfigurationOption id can't be null");
        }
        try {
            os.writeObject(id);
            os.writeBoolean(configOption.isCreate());
            os.writeBoolean(configOption.isOverride());
            os.writeBoolean(configOption.isFactory());
            Map<String, ?> properties = configOption.getProperties();
            if (properties == null) {
                throw new TestContainerException("ConfigurationOption properties can't be null");
            }
            try {
                os.writeObject(new HashMap(properties));
            }
            catch (NotSerializableException e) {
                throw new TestContainerException("One of the values of the ConfigurationOption properties are not serializable", (Throwable)e);
            }
            os.flush();
            os.close();
        }
        catch (IOException e) {
            throw new TestContainerException("Writing object data failed", (Throwable)e);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(outputStream.toByteArray());
        TinyBundle bundle = TinyBundles.bundle();
        bundle.add(ConfigurationOptionConfigurationListener.class);
        bundle.add(ConfigurationOptionActivator.class).add("override.obj", (InputStream)stream);
        bundle.set("Bundle-SymbolicName", "PAXExamConfigurationOption-" + UUID.randomUUID());
        bundle.set("Import-Package", "org.osgi.framework,org.osgi.service.cm,org.osgi.util.tracker,org.slf4j");
        bundle.set("Bundle-Activator", ConfigurationOptionActivator.class.getName());
        bundle.set("Bundle-ManifestVersion", "2");
        return (ProvisionOption)((UrlProvisionOption)((UrlProvisionOption)CoreOptions.streamBundle((InputStream)bundle.build()).startLevel(Integer.valueOf(1))).start(Boolean.valueOf(true))).update(Boolean.valueOf(false));
    }
}

