/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.ops4j.pax.exam.karaf.container.internal.KarafConfigurationFile;

public class KarafConfigFile
extends KarafConfigurationFile {
    private Dictionary configuration = new Hashtable();

    public KarafConfigFile(File karafHome, String location) {
        super(karafHome, location);
    }

    @Override
    public void store() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        ConfigurationHandler.write((OutputStream)fos, (Dictionary)this.configuration);
        fos.close();
    }

    @Override
    public void load() throws IOException {
        if (!this.file.exists()) {
            return;
        }
        FileInputStream fis = new FileInputStream(this.file);
        this.configuration = ConfigurationHandler.read((InputStream)fis);
        fis.close();
    }

    @Override
    public void put(String key, Object value) {
        this.configuration.put(key, value);
    }

    @Override
    public void extend(String key, Object value) {
        Object v = this.configuration.get(key);
        if (v == null) {
            Object array = Array.newInstance(value.getClass(), 1);
            Array.set(array, 0, value);
            this.configuration.put(key, array);
        } else {
            Class<?> clazz = v.getClass();
            if (clazz.isArray()) {
                int length = Array.getLength(v);
                Object array = Array.newInstance(clazz.getComponentType(), length + 1);
                System.arraycopy(v, 0, array, 0, length);
                Array.set(array, length, value);
                this.configuration.put(key, array);
            } else if (v instanceof Collection) {
                ((Collection)v).add(value);
            } else {
                String message = String.format("Cannot extend %s by %s.", key, value);
                throw new IllegalArgumentException(message);
            }
        }
    }

    @Override
    public Object get(String key) {
        return this.configuration.get(key);
    }
}

