/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public abstract class KarafConfigurationFile {
    protected final File file;

    public KarafConfigurationFile(File karafHome, String location) {
        this.file = location.startsWith("/") ? new File(karafHome + location) : new File(karafHome + "/" + location);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void replace(File source) {
        try {
            FileUtils.copyFile((File)source, (File)this.file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error occurred while replacing file " + this.file, e);
        }
    }

    public abstract void store() throws IOException;

    public abstract void load() throws IOException;

    public abstract void put(String var1, Object var2);

    public abstract void extend(String var1, Object var2);

    public abstract Object get(String var1);
}

