/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal.runner;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.ops4j.io.Pipe;
import org.ops4j.pax.exam.karaf.container.internal.runner.CommandLineBuilder;

public class InternalRunner {
    private Process frameworkProcess;
    private Object frameworkProcessMonitor = new Object();
    private Thread shutdownHook;
    private final Object shutdownHookMonitor = new Object();

    public synchronized void exec(CommandLineBuilder commandLine, File workingDirectory, String[] envOptions) {
        if (this.frameworkProcess != null) {
            throw new IllegalStateException("Platform already started");
        }
        try {
            this.frameworkProcess = Runtime.getRuntime().exec(commandLine.toArray(), this.createEnvironmentVars(envOptions), workingDirectory);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not start up the process", e);
        }
        this.shutdownHook = this.createShutdownHook(this.frameworkProcess);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.waitForExit();
    }

    private String[] createEnvironmentVars(String[] envOptions) {
        ArrayList<String> env = new ArrayList<String>();
        Map<String, String> getenv = System.getenv();
        for (String key : getenv.keySet()) {
            env.add(key + "=" + getenv.get(key));
        }
        if (envOptions != null) {
            Collections.addAll(env, envOptions);
        }
        return env.toArray(new String[env.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block6: {
            try {
                if (this.shutdownHook == null) break block6;
                Object object = this.shutdownHookMonitor;
                synchronized (object) {
                    if (this.shutdownHook != null) {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                        this.frameworkProcess = null;
                        this.shutdownHook.run();
                        this.shutdownHook = null;
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit() {
        if (this.shutdownHook != null) {
            Object object = this.shutdownHookMonitor;
            synchronized (object) {
                if (this.shutdownHook != null) {
                    Object object2 = this.frameworkProcessMonitor;
                    synchronized (object2) {
                        try {
                            this.frameworkProcess.waitFor();
                            this.shutdown();
                        }
                        catch (Throwable e) {
                            this.shutdown();
                        }
                    }
                }
            }
        }
    }

    private Thread createShutdownHook(final Process process) {
        final Pipe errPipe = new Pipe(process.getErrorStream(), (OutputStream)System.err).start("Error pipe");
        final Pipe outPipe = new Pipe(process.getInputStream(), (OutputStream)System.out).start("Out pipe");
        final Pipe inPipe = new Pipe(process.getOutputStream(), System.in).start("In pipe");
        return new Thread(new Runnable(){

            @Override
            public void run() {
                inPipe.stop();
                outPipe.stop();
                errPipe.stop();
                try {
                    process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, "Pax-Runner shutdown hook");
    }
}

