/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.ops4j.pax.exam.karaf.container.internal.JoinUtil;

public class KarafPropertiesFile {
    private final Properties properties;
    private final File propertyFile;

    public KarafPropertiesFile(File karafHome, String location) {
        this.propertyFile = location.startsWith("/") ? new File(karafHome + location) : new File(karafHome + "/" + location);
        this.properties = new Properties();
    }

    public boolean exists() {
        return this.propertyFile.exists();
    }

    public void load() throws IOException {
        if (!this.propertyFile.exists()) {
            return;
        }
        this.properties.load(new FileInputStream(this.propertyFile));
    }

    public void put(String key, String value) {
        this.properties.put(key, value);
    }

    public void extend(String key, String value) {
        if (this.properties.get(key) == null) {
            this.properties.put(key, value);
            return;
        }
        this.properties.put(key, JoinUtil.join((String)this.properties.get(key), value));
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public void store() throws IOException {
        this.properties.store(new FileOutputStream(this.propertyFile), "Modified by paxexam");
    }

    public void replace(File source) {
        try {
            FileUtils.copyFile((File)source, (File)this.propertyFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("It is required to replace propertyFile", e);
        }
    }
}

