/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal.runner;

import java.io.File;
import org.ops4j.pax.exam.karaf.container.internal.runner.CommandLineBuilder;
import org.ops4j.pax.exam.karaf.container.internal.runner.InternalRunner;
import org.ops4j.pax.exam.karaf.container.internal.runner.Runner;

public class KarafJavaRunner
implements Runner {
    private InternalRunner runner = new InternalRunner();

    @Override
    public synchronized void exec(final String[] environment, final File karafBase, final String javaHome, final String[] javaOpts, final String[] javaEndorsedDirs, final String[] javaExtDirs, final String karafHome, final String karafData, final String karafEtc, final String[] karafOpts, final String[] opts, final String[] classPath, final String main, final String options, final boolean security) {
        Thread thread = new Thread("KarafJavaRunner"){

            @Override
            public void run() {
                String cp = this.buildCmdSeparatedString(classPath);
                String endDirs = this.buildCmdSeparatedString(javaEndorsedDirs);
                String extDirs = this.buildCmdSeparatedString(javaExtDirs);
                CommandLineBuilder commandLine = null;
                commandLine = System.getProperty("java.version").startsWith("9") ? new CommandLineBuilder().append(this.getJavaExecutable(javaHome)).append(javaOpts).append("--add-exports=java.base/sun.net.www.protocol.http=ALL-UNNAMED").append("--add-exports=java.base/sun.net.www.protocol.https=ALL-UNNAMED").append("--add-exports=java.xml.bind/com.sun.xml.internal.bind.v2.runtime=ALL-UNNAMED").append("--add-exports=jdk.xml.dom/org.w3c.dom.html=ALL-UNNAMED").append("--add-exports=jdk.naming.rmi/com.sun.jndi.url.rmi=ALL-UNNAMED").append("--add-modules").append("java.annotations.common,java.corba,java.transaction,java.xml.bind,java.xml.ws,jdk.xml.bind").append("-Dkaraf.instances=" + karafHome + "/instances").append("-Dkaraf.home=" + karafHome).append("-Dkaraf.base=" + karafBase).append("-Dkaraf.data=" + karafData).append("-Dkaraf.etc=" + karafEtc).append("-Djava.util.logging.config.file=" + karafEtc + "/java.util.logging.properties") : new CommandLineBuilder().append(this.getJavaExecutable(javaHome)).append(javaOpts).append("-Djava.endorsed.dirs=" + endDirs).append("-Djava.ext.dirs=" + extDirs).append("-Dkaraf.instances=" + karafHome + "/instances").append("-Dkaraf.home=" + karafHome).append("-Dkaraf.base=" + karafBase).append("-Dkaraf.data=" + karafData).append("-Dkaraf.etc=" + karafEtc).append("-Djava.util.logging.config.file=" + karafEtc + "/java.util.logging.properties");
                if (security) {
                    commandLine.append("-Djavax.management.builder.initial=org.apache.karaf.management.boot.KarafMBeanServerBuilder");
                }
                commandLine.append(karafOpts).append(opts).append("-cp").append(cp).append(main).append(options);
                KarafJavaRunner.this.runner.exec(commandLine, karafBase, environment);
            }

            private String buildCmdSeparatedString(String[] splitted) {
                StringBuilder together = new StringBuilder();
                for (String path : splitted) {
                    if (together.length() != 0) {
                        together.append(File.pathSeparator);
                    }
                    together.append(path);
                }
                return together.toString();
            }

            private String getJavaExecutable(String javaHome2) {
                if (javaHome2 == null) {
                    throw new IllegalStateException("JAVA_HOME is not set.");
                }
                return javaHome2 + "/bin/java";
            }
        };
        thread.start();
    }

    @Override
    public synchronized void shutdown() {
        this.runner.shutdown();
    }
}

