/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.nat.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeInvoker;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.options.BootDelegationOption;
import org.ops4j.pax.exam.options.FrameworkPropertyOption;
import org.ops4j.pax.exam.options.FrameworkStartLevelOption;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.SystemPackageOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.ValueOption;
import org.ops4j.pax.exam.options.extra.CleanCachesOption;
import org.ops4j.pax.exam.options.extra.RepositoryOption;
import org.ops4j.pax.swissbox.framework.ServiceLookup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.startlevel.StartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeTestContainer
implements TestContainer {
    private static final Logger LOG = LoggerFactory.getLogger(NativeTestContainer.class);
    private static final String PROBE_SIGNATURE_KEY = "Probe-Signature";
    private final Stack<Long> m_installed = new Stack();
    private final FrameworkFactory m_frameworkFactory;
    private ExamSystem m_system;
    volatile Framework m_framework;

    public NativeTestContainer(ExamSystem system, FrameworkFactory frameworkFactory) throws IOException {
        this.m_frameworkFactory = frameworkFactory;
        this.m_system = system;
    }

    public synchronized void call(TestAddress address) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROBE_SIGNATURE_KEY, address.root().identifier());
        ProbeInvoker service = (ProbeInvoker)ServiceLookup.getService((BundleContext)this.m_framework.getBundleContext(), ProbeInvoker.class, props);
        service.call(address.arguments());
    }

    public synchronized long install(String location, InputStream stream) {
        try {
            Bundle b = this.m_framework.getBundleContext().installBundle(location, stream);
            this.m_installed.push(b.getBundleId());
            LOG.debug("Installed bundle " + b.getSymbolicName() + " as Bundle ID " + b.getBundleId());
            this.setBundleStartLevel(b.getBundleId(), 5);
            b.start();
            return b.getBundleId();
        }
        catch (BundleException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public synchronized long install(InputStream stream) {
        return this.install("local", stream);
    }

    public synchronized void cleanup() {
        while (!this.m_installed.isEmpty()) {
            try {
                Long id = this.m_installed.pop();
                Bundle bundle = this.m_framework.getBundleContext().getBundle(id.longValue());
                bundle.uninstall();
                LOG.debug("Uninstalled bundle " + id);
            }
            catch (BundleException bundleException) {}
        }
    }

    public void setBundleStartLevel(long bundleId, int startLevel) throws TestContainerException {
        StartLevel sl = (StartLevel)ServiceLookup.getService((BundleContext)this.m_framework.getBundleContext(), StartLevel.class);
        sl.setBundleStartLevel(this.m_framework.getBundleContext().getBundle(bundleId), startLevel);
    }

    public TestContainer start() throws TestContainerException {
        ClassLoader parent = null;
        try {
            this.m_system = this.m_system.fork(new Option[]{CoreOptions.systemPackage((String)("org.ops4j.pax.exam;version=" + this.skipSnapshotFlag(Info.getPaxExamVersion()))), CoreOptions.systemPackage((String)("org.ops4j.pax.exam.options;version=" + this.skipSnapshotFlag(Info.getPaxExamVersion()))), CoreOptions.systemPackage((String)("org.ops4j.pax.exam.util;version=" + this.skipSnapshotFlag(Info.getPaxExamVersion()))), CoreOptions.systemProperty((String)"java.protocol.handler.pkgs").value("org.ops4j.pax.url")});
            Map<String, Object> p = this.createFrameworkProperties();
            if (LOG.isDebugEnabled()) {
                this.logFrameworkProperties(p);
                this.logSystemProperties();
            }
            parent = Thread.currentThread().getContextClassLoader();
            this.m_framework = this.m_frameworkFactory.newFramework(p);
            this.m_framework.init();
            this.installAndStartBundles(this.m_framework.getBundleContext());
            if (parent != null) {
                Thread.currentThread().setContextClassLoader(parent);
            }
        }
        catch (Exception e) {
            try {
                throw new TestContainerException("Problem starting test container.", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (parent != null) {
                    Thread.currentThread().setContextClassLoader(parent);
                }
                throw throwable;
            }
        }
        return this;
    }

    private void logFrameworkProperties(Map<String, Object> p) {
        LOG.debug("==== Framework properties:");
        for (String key : p.keySet()) {
            LOG.debug("{} = {}", (Object)key, p.get(key));
        }
    }

    private void logSystemProperties() {
        LOG.debug("==== System properties:");
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(System.getProperties());
        for (Map.Entry entry : map.entrySet()) {
            LOG.debug("{} = {}", entry.getKey(), entry.getValue());
        }
    }

    public TestContainer stop() {
        if (this.m_framework != null) {
            try {
                this.cleanup();
                this.stopOrAbort();
                this.m_framework = null;
                this.m_system.clear();
            }
            catch (BundleException e) {
                LOG.warn("Problem during stopping fw.", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException during stopping fw.", (Throwable)e);
            }
        } else {
            LOG.warn("Framework does not exist. Called start() before ? ");
        }
        return this;
    }

    private void stopOrAbort() throws BundleException, InterruptedException {
        this.m_framework.stop();
        long timeout = this.m_system.getTimeout().getValue();
        Stopper stopper = new Stopper(timeout);
        stopper.start();
        stopper.join(timeout + 500L);
        if (this.m_framework.getState() != 4) {
            String message = "Framework has not yet stopped after " + timeout + " ms. waitForStop did not return";
            throw new TestContainerException(message);
        }
    }

    private Map<String, Object> createFrameworkProperties() throws IOException {
        HashMap<String, Object> p = new HashMap<String, Object>();
        CleanCachesOption cleanCaches = (CleanCachesOption)this.m_system.getSingleOption(CleanCachesOption.class);
        if (cleanCaches != null && cleanCaches.getValue() != null && cleanCaches.getValue().booleanValue()) {
            p.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        p.put("org.osgi.framework.storage", this.m_system.getTempFolder().getAbsolutePath());
        p.put("org.osgi.framework.system.packages.extra", this.buildString((ValueOption[])this.m_system.getOptions(SystemPackageOption.class)));
        p.put("org.osgi.framework.bootdelegation", this.buildString((ValueOption[])this.m_system.getOptions(BootDelegationOption.class)));
        for (FrameworkPropertyOption frameworkPropertyOption : (FrameworkPropertyOption[])this.m_system.getOptions(FrameworkPropertyOption.class)) {
            p.put(frameworkPropertyOption.getKey(), frameworkPropertyOption.getValue());
        }
        for (FrameworkPropertyOption frameworkPropertyOption : (SystemPropertyOption[])this.m_system.getOptions(SystemPropertyOption.class)) {
            System.setProperty(frameworkPropertyOption.getKey(), frameworkPropertyOption.getValue());
        }
        String repositories = this.buildString((ValueOption[])this.m_system.getOptions(RepositoryOption.class));
        if (!repositories.isEmpty()) {
            System.setProperty("org.ops4j.pax.url.mvn.repositories", repositories);
        }
        return p;
    }

    private String buildString(ValueOption<?>[] options) {
        return this.buildString(new String[0], options, new String[0]);
    }

    private String buildString(String[] prepend, ValueOption<?>[] options) {
        return this.buildString(prepend, options, new String[0]);
    }

    private String buildString(ValueOption<?>[] options, String[] append) {
        return this.buildString(new String[0], options, append);
    }

    private String buildString(String[] prepend, ValueOption<?>[] options, String[] append) {
        StringBuilder builder = new StringBuilder();
        for (String string : prepend) {
            builder.append(string);
            builder.append(",");
        }
        for (String string : options) {
            builder.append(string.getValue());
            builder.append(",");
        }
        for (String string : append) {
            builder.append(string);
            builder.append(",");
        }
        if (builder.length() > 0) {
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    private void installAndStartBundles(BundleContext context) throws BundleException {
        this.m_framework.start();
        StartLevel sl = (StartLevel)ServiceLookup.getService((BundleContext)context, StartLevel.class);
        for (ProvisionOption bundle : (ProvisionOption[])this.m_system.getOptions(ProvisionOption.class)) {
            Bundle b = context.installBundle(bundle.getURL());
            int startLevel = this.getStartLevel(bundle);
            sl.setBundleStartLevel(b, startLevel);
            if (bundle.shouldStart()) {
                b.start();
                LOG.debug("+ Install (start@{}) {}", (Object)startLevel, (Object)bundle);
                continue;
            }
            LOG.debug("+ Install (no start) {}", (Object)bundle);
        }
        FrameworkStartLevelOption startLevelOption = (FrameworkStartLevelOption)this.m_system.getSingleOption(FrameworkStartLevelOption.class);
        int startLevel = startLevelOption == null ? 5 : startLevelOption.getStartLevel();
        LOG.debug("Jump to startlevel: " + startLevel);
        sl.setStartLevel(startLevel);
        final CountDownLatch latch = new CountDownLatch(1);
        context.addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                switch (frameworkEvent.getType()) {
                    case 8: {
                        latch.countDown();
                    }
                }
            }
        });
        try {
            long timeout = this.m_system.getTimeout().getLowerValue();
            if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                String message = "Framework is yet to reach target start level " + startLevel + " after " + timeout + " ms. Current start level is " + sl.getStartLevel();
                throw new TestContainerException(message);
            }
        }
        catch (InterruptedException e) {
            throw new TestContainerException((Throwable)e);
        }
    }

    private int getStartLevel(ProvisionOption<?> bundle) {
        Integer start = bundle.getStartLevel();
        if (start == null) {
            start = 3;
        }
        return start;
    }

    private String skipSnapshotFlag(String version) {
        int idx = version.indexOf("-");
        if (idx >= 0) {
            return version.substring(0, idx);
        }
        return version;
    }

    public String toString() {
        return "Native:" + this.m_frameworkFactory.getClass().getSimpleName();
    }

    private class Stopper
    extends Thread {
        private final long timeout;

        private Stopper(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                FrameworkEvent frameworkEvent = NativeTestContainer.this.m_framework.waitForStop(this.timeout);
                if (frameworkEvent.getType() != 64) {
                    LOG.error("Framework has not yet stopped after {} ms. waitForStop returned: {}", (Object)this.timeout, (Object)frameworkEvent);
                }
            }
            catch (InterruptedException exc) {
                LOG.error("Stopper thread was interrupted");
            }
        }
    }
}

