/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.def.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.options.BootClasspathLibraryOption;
import org.ops4j.pax.exam.options.BootDelegationOption;
import org.ops4j.pax.exam.options.BundleStartLevelOption;
import org.ops4j.pax.exam.options.CustomFrameworkOption;
import org.ops4j.pax.exam.options.DebugClassLoadingOption;
import org.ops4j.pax.exam.options.FrameworkOption;
import org.ops4j.pax.exam.options.FrameworkPropertyOption;
import org.ops4j.pax.exam.options.FrameworkStartLevelOption;
import org.ops4j.pax.exam.options.MavenPluginGeneratedConfigOption;
import org.ops4j.pax.exam.options.ProvisionOption;
import org.ops4j.pax.exam.options.SystemPackageOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.extra.AutoWrapOption;
import org.ops4j.pax.exam.options.extra.BundleScannerProvisionOption;
import org.ops4j.pax.exam.options.extra.CleanCachesOption;
import org.ops4j.pax.exam.options.extra.ExcludeDefaultRepositoriesOption;
import org.ops4j.pax.exam.options.extra.LocalRepositoryOption;
import org.ops4j.pax.exam.options.extra.ProfileOption;
import org.ops4j.pax.exam.options.extra.RawPaxRunnerOptionOption;
import org.ops4j.pax.exam.options.extra.RepositoryOptionImpl;
import org.ops4j.pax.exam.options.extra.Scanner;
import org.ops4j.pax.exam.options.extra.VMOption;

class ArgumentsBuilder {
    private boolean argsSetManually = false;
    private final List<String> m_paxrunneArguments = new ArrayList<String>();

    ArgumentsBuilder(ExamSystem system, FrameworkOption selectedFramework) throws IOException {
        this.add(this.m_paxrunneArguments, this.extractArguments((RawPaxRunnerOptionOption[])system.getOptions(RawPaxRunnerOptionOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((MavenPluginGeneratedConfigOption[])system.getOptions(MavenPluginGeneratedConfigOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments(selectedFramework));
        this.add(this.m_paxrunneArguments, ArgumentsBuilder.extractArguments((ProfileOption[])system.getOptions(ProfileOption.class)));
        this.add(this.m_paxrunneArguments, ArgumentsBuilder.extractArguments((BootDelegationOption[])system.getOptions(BootDelegationOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((SystemPackageOption[])system.getOptions(SystemPackageOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((ProvisionOption[])system.getOptions(ProvisionOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((RepositoryOptionImpl[])system.getOptions(RepositoryOptionImpl.class), (ExcludeDefaultRepositoriesOption[])system.getOptions(ExcludeDefaultRepositoriesOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((AutoWrapOption[])system.getOptions(AutoWrapOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((CleanCachesOption[])system.getOptions(CleanCachesOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((LocalRepositoryOption[])system.getOptions(LocalRepositoryOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((FrameworkStartLevelOption[])system.getOptions(FrameworkStartLevelOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((BundleStartLevelOption[])system.getOptions(BundleStartLevelOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((SystemPropertyOption[])system.getOptions(SystemPropertyOption.class), (FrameworkPropertyOption[])system.getOptions(FrameworkPropertyOption.class), (VMOption[])system.getOptions(VMOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((BootClasspathLibraryOption[])system.getOptions(BootClasspathLibraryOption.class)));
        this.add(this.m_paxrunneArguments, this.extractArguments((DebugClassLoadingOption[])system.getOptions(DebugClassLoadingOption.class)));
        this.add(this.m_paxrunneArguments, this.defaultArguments(system));
    }

    public String[] get() {
        return this.m_paxrunneArguments.toArray(new String[this.m_paxrunneArguments.size()]);
    }

    public static String[] build(ExamSystem system, FrameworkOption selectedFramework) throws IOException {
        return new ArgumentsBuilder(system, selectedFramework).get();
    }

    private List<ProvisionOption<?>> wrap(ProvisionOption<?>[] options) {
        ArrayList processed = new ArrayList();
        for (ProvisionOption<?> provisionOption : options) {
            if (!(provisionOption instanceof Scanner)) {
                processed.add((ProvisionOption<?>)((BundleScannerProvisionOption)((BundleScannerProvisionOption)CoreOptions.scanBundle(provisionOption).start(Boolean.valueOf(provisionOption.shouldStart()))).startLevel(provisionOption.getStartLevel())).update(Boolean.valueOf(provisionOption.shouldUpdate())));
                continue;
            }
            processed.add(provisionOption);
        }
        return processed;
    }

    private void add(List<String> arguments, Collection<String> argumentsToAdd) {
        if (argumentsToAdd != null && argumentsToAdd.size() > 0) {
            arguments.addAll(argumentsToAdd);
        }
    }

    private void add(List<String> arguments, String argument) {
        if (argument != null && argument.trim().length() > 0) {
            arguments.add(argument);
        }
    }

    private Collection<String> defaultArguments(ExamSystem system) throws IOException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--noConsole");
        arguments.add("--noDownloadFeedback");
        arguments.add("--log=warn");
        if (!this.argsSetManually) {
            arguments.add("--noArgs");
        }
        arguments.add("--workingDirectory=" + system.getTempFolder());
        return arguments;
    }

    private Collection<String> extractArguments(FrameworkOption framework) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (framework instanceof CustomFrameworkOption) {
            String basePlatform = ((CustomFrameworkOption)framework).getBasePlatform();
            if (basePlatform != null && basePlatform.trim().length() > 0) {
                arguments.add("--platform=" + basePlatform);
            }
            arguments.add("--definitionURL=" + ((CustomFrameworkOption)framework).getDefinitionURL());
        } else {
            arguments.add("--platform=" + framework.getName());
            String version = framework.getVersion();
            if (version != null && version.trim().length() > 0) {
                arguments.add("--version=" + version);
            }
        }
        return arguments;
    }

    private Collection<String> extractArguments(MavenPluginGeneratedConfigOption[] mavenPluginGeneratedConfigOption) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (MavenPluginGeneratedConfigOption arg : mavenPluginGeneratedConfigOption) {
            URL url = arg.getURL();
            arguments.add("--args=" + url.toExternalForm());
        }
        this.argsSetManually = true;
        return arguments;
    }

    private Collection<String> extractArguments(ProvisionOption<?>[] bundles) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (ProvisionOption<?> bundle : this.wrap(bundles)) {
            arguments.add(bundle.getURL());
        }
        return arguments;
    }

    private static String extractArguments(ProfileOption[] profiles) {
        StringBuilder argument = new StringBuilder();
        if (profiles != null && profiles.length > 0) {
            for (ProfileOption profile : profiles) {
                if (profile == null || profile.getProfile() == null || profile.getProfile().length() <= 0) continue;
                if (argument.length() == 0) {
                    argument.append("--profiles=");
                } else {
                    argument.append(",");
                }
                argument.append(profile.getProfile());
            }
        }
        return argument.toString();
    }

    private static String extractArguments(BootDelegationOption[] packages) {
        StringBuilder argument = new StringBuilder();
        if (packages != null && packages.length > 0) {
            for (BootDelegationOption pkg : packages) {
                if (pkg == null || pkg.getPackage() == null || pkg.getPackage().length() <= 0) continue;
                if (argument.length() == 0) {
                    argument.append("--bootDelegation=");
                } else {
                    argument.append(",");
                }
                argument.append(pkg.getPackage());
            }
        }
        return argument.toString();
    }

    private String extractArguments(SystemPackageOption[] packages) {
        StringBuilder argument = new StringBuilder();
        if (packages != null && packages.length > 0) {
            for (SystemPackageOption pkg : packages) {
                if (pkg == null || pkg.getPackage() == null || pkg.getPackage().length() <= 0) continue;
                if (argument.length() == 0) {
                    argument.append("--systemPackages=");
                } else {
                    argument.append(",");
                }
                argument.append(pkg.getPackage());
            }
        }
        return argument.toString();
    }

    private String extractArguments(SystemPropertyOption[] systemProperties, FrameworkPropertyOption[] frameworkProperties, VMOption[] vmOptions) {
        StringBuilder argument = new StringBuilder();
        if (systemProperties != null && systemProperties.length > 0) {
            for (SystemPropertyOption systemPropertyOption : systemProperties) {
                if (systemPropertyOption == null || systemPropertyOption.getKey() == null || systemPropertyOption.getKey().trim().length() <= 0) continue;
                if (argument.length() > 0) {
                    argument.append(" ");
                }
                argument.append("-D").append(systemPropertyOption.getKey()).append("=").append(systemPropertyOption.getValue());
            }
        }
        if (frameworkProperties != null && frameworkProperties.length > 0) {
            for (SystemPropertyOption systemPropertyOption : frameworkProperties) {
                if (systemPropertyOption == null || systemPropertyOption.getKey() == null || systemPropertyOption.getKey().trim().length() <= 0) continue;
                if (argument.length() > 0) {
                    argument.append(" ");
                }
                argument.append("-D").append(systemPropertyOption.getKey()).append("=").append(systemPropertyOption.getValue());
            }
        }
        if (vmOptions != null && vmOptions.length > 0) {
            for (SystemPropertyOption systemPropertyOption : vmOptions) {
                if (systemPropertyOption == null || systemPropertyOption.getOption() == null || systemPropertyOption.getOption().trim().length() <= 0) continue;
                if (argument.length() > 0) {
                    argument.append(" ");
                }
                argument.append(systemPropertyOption.getOption());
            }
        }
        if (argument.length() > 0) {
            argument.insert(0, "--vmOptions=");
        }
        return argument.toString();
    }

    private String extractArguments(RepositoryOptionImpl[] repositoriesOptions, ExcludeDefaultRepositoriesOption[] excludeDefaultRepositoriesOptions) {
        boolean excludeDefaultRepositories;
        StringBuilder argument = new StringBuilder();
        boolean bl = excludeDefaultRepositories = excludeDefaultRepositoriesOptions.length > 0;
        if (repositoriesOptions.length > 0 || excludeDefaultRepositories) {
            argument.append("--repositories=");
            if (!excludeDefaultRepositories) {
                argument.append("+");
            }
            for (int i = 0; i < repositoriesOptions.length; ++i) {
                argument.append(repositoriesOptions[i].getRepository());
                if (i + 1 >= repositoriesOptions.length) continue;
                argument.append(",");
            }
        }
        return argument.toString();
    }

    private String extractArguments(AutoWrapOption[] autoWrapOptions) {
        if (autoWrapOptions.length > 0) {
            return "--autoWrap";
        }
        return null;
    }

    private String extractArguments(CleanCachesOption[] cleanCachesOption) {
        Boolean cleanCaches;
        if (cleanCachesOption.length > 0 && (cleanCaches = cleanCachesOption[0].getValue()) != null && cleanCaches.booleanValue()) {
            return "--clean";
        }
        return null;
    }

    private String extractArguments(LocalRepositoryOption[] localRepositoryOptions) {
        if (localRepositoryOptions != null && localRepositoryOptions.length > 0) {
            LocalRepositoryOption local = localRepositoryOptions[0];
            return "--localRepository=" + local.getLocalRepositoryPath();
        }
        return null;
    }

    private List<String> extractArguments(RawPaxRunnerOptionOption[] paxrunnerOptions) {
        boolean excludeDefaultRepositories;
        ArrayList<String> args = new ArrayList<String>();
        boolean bl = excludeDefaultRepositories = paxrunnerOptions.length > 0;
        if (paxrunnerOptions.length > 0 || excludeDefaultRepositories) {
            for (int i = 0; i < paxrunnerOptions.length; ++i) {
                args.add(paxrunnerOptions[i].getOption().trim());
            }
        }
        return args;
    }

    private Collection<String> extractArguments(FrameworkStartLevelOption[] startLevels) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (startLevels.length > 1) {
            throw new IllegalArgumentException("Configuration cannot contain more then one framework start level");
        }
        if (startLevels.length > 0) {
            arguments.add("--startLevel=" + startLevels[0].getStartLevel());
        }
        return arguments;
    }

    private Collection<String> extractArguments(BundleStartLevelOption[] startLevels) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (startLevels.length > 1) {
            throw new IllegalArgumentException("Configuration cannot contain more then one bundle start level");
        }
        if (startLevels.length > 0) {
            arguments.add("--bundleStartLevel=" + startLevels[0].getStartLevel());
        }
        return arguments;
    }

    private Collection<String> extractArguments(BootClasspathLibraryOption[] libraries) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (BootClasspathLibraryOption library : libraries) {
            if (library.isBeforeFramework()) {
                arguments.add("--bcp/p=" + library.getLibraryUrl().getURL());
                continue;
            }
            arguments.add("--bcp/a=" + library.getLibraryUrl().getURL());
        }
        return arguments;
    }

    private String extractArguments(DebugClassLoadingOption[] debugClassLoadingOptions) {
        if (debugClassLoadingOptions.length > 0) {
            return "--debugClassLoading";
        }
        return null;
    }
}

