/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.remote;

import java.io.InputStream;
import org.ops4j.pax.exam.RelativeTimeout;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TimeoutException;
import org.ops4j.pax.exam.rbc.client.RemoteBundleContextClient;
import org.ops4j.pax.exam.rbc.client.intern.RemoteBundleContextClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBCRemoteTarget
implements TestContainer {
    private static final Logger LOG = LoggerFactory.getLogger(RBCRemoteTarget.class);
    private RemoteBundleContextClient m_remoteBundleContextClient;
    private RelativeTimeout m_timeout;

    public RBCRemoteTarget(String name, Integer registry, RelativeTimeout timeout) {
        this.m_timeout = timeout;
        this.m_remoteBundleContextClient = new RemoteBundleContextClientImpl(name, registry, timeout);
    }

    public RemoteBundleContextClient getClientRBC() {
        return this.m_remoteBundleContextClient;
    }

    public void call(TestAddress address) {
        LOG.debug("call [" + address + "]");
        this.m_remoteBundleContextClient.call(address);
    }

    public TestContainer start() throws TimeoutException {
        return this;
    }

    public long install(String location, InputStream probe) throws TestContainerException {
        LOG.debug("Preparing and Installing bundle (from stream )..");
        long id = 0L;
        id = this.m_remoteBundleContextClient.install(location, probe);
        LOG.debug("Installed bundle (from stream) as ID: " + id);
        return id;
    }

    public long install(InputStream probe) throws TestContainerException {
        return this.install("local", probe);
    }

    public TestContainer stop() throws TimeoutException {
        this.m_remoteBundleContextClient.cleanup();
        return this;
    }
}

