/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.remote;

import java.io.InputStream;
import org.ops4j.pax.exam.RelativeTimeout;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.rbc.client.RemoteBundleContextClient;
import org.ops4j.pax.exam.rbc.client.intern.RemoteBundleContextClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBCRemoteTarget
implements TestContainer {
    private static final Logger LOG = LoggerFactory.getLogger(RBCRemoteTarget.class);
    private RemoteBundleContextClient remoteBundleContextClient;
    private Long probeId;

    public RBCRemoteTarget(String name, Integer registry, RelativeTimeout timeout) {
        this.remoteBundleContextClient = new RemoteBundleContextClientImpl(name, registry, timeout);
    }

    public RemoteBundleContextClient getClientRBC() {
        return this.remoteBundleContextClient;
    }

    public void call(TestAddress address) {
        LOG.debug("call [" + address + "]");
        this.remoteBundleContextClient.call(address);
    }

    public TestContainer start() {
        return this;
    }

    public long install(String location, InputStream probe) {
        LOG.debug("Preparing and Installing bundle (from stream )..");
        long id = 0L;
        id = this.remoteBundleContextClient.install(location, probe);
        LOG.debug("Installed bundle (from stream) as ID: " + id);
        return id;
    }

    public long install(InputStream probe) {
        return this.install("local", probe);
    }

    public TestContainer stop() {
        this.remoteBundleContextClient.cleanup();
        return this;
    }

    public long installProbe(InputStream stream) {
        this.probeId = this.install(stream);
        return this.probeId;
    }

    public void uninstallProbe() {
        this.remoteBundleContextClient.uninstall(this.probeId.longValue());
    }
}

