/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.raw.extender.intern;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ops4j.pax.exam.ProbeInvoker;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.raw.extender.intern.NoOpInjector;
import org.ops4j.pax.exam.util.Injector;
import org.ops4j.pax.swissbox.framework.ServiceLookup;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeInvokerImpl
implements ProbeInvoker {
    private BundleContext m_ctx;
    private String m_clazz;
    private String m_method;
    private Injector m_injector;

    public ProbeInvokerImpl(String encodedInstruction, BundleContext bundleContext) {
        String[] parts = encodedInstruction.split(";");
        this.m_clazz = parts[0];
        this.m_method = parts[1];
        this.m_ctx = bundleContext;
        boolean inject = true;
        this.m_injector = inject ? (Injector)ServiceLookup.getService((BundleContext)this.m_ctx, Injector.class) : new NoOpInjector();
    }

    public void call(Object ... args) {
        Class testClass;
        try {
            testClass = this.m_ctx.getBundle().loadClass(this.m_clazz);
        }
        catch (ClassNotFoundException e) {
            throw new TestContainerException((Throwable)e);
        }
        if (!this.findAndInvoke(testClass, args)) {
            throw new TestContainerException(" Test " + this.m_method + " not found in test class " + testClass.getName());
        }
    }

    private boolean findAndInvoke(Class<?> testClass, Object ... params) {
        try {
            for (Method m : testClass.getMethods()) {
                if (!m.getName().equals(this.m_method)) continue;
                this.injectContextAndInvoke(testClass.newInstance(), m, params);
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            throw new TestContainerException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new TestContainerException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestContainerException((Throwable)e);
        }
        return false;
    }

    private void injectContextAndInvoke(Object testInstance, Method testMethod, Object[] params) throws TestContainerException {
        Class<?>[] paramTypes = testMethod.getParameterTypes();
        this.m_injector.injectFields(this.m_ctx, testInstance);
        boolean cleanup = false;
        try {
            if (paramTypes.length == 0) {
                testMethod.invoke(testInstance, new Object[0]);
            } else {
                params = this.injectHook(testMethod, params);
                testMethod.invoke(testInstance, params);
            }
            cleanup = true;
        }
        catch (InvocationTargetException e) {
            throw new TestContainerException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestContainerException((Throwable)e);
        }
        finally {
            if (!cleanup) {
                // empty if block
            }
        }
    }

    private Object[] injectHook(Method testMethod, Object[] params) {
        Class<?>[] paramTypes = testMethod.getParameterTypes();
        Object[] ret = new Object[paramTypes.length];
        Annotation[][] paramAnnotations = testMethod.getParameterAnnotations();
        int paramCursor = 0;
        for (int i = 0; i < ret.length; ++i) {
            if (i == 0) {
                ret[0] = this.m_ctx;
                continue;
            }
            if (paramAnnotations[i].length > 0) {
                throw new RuntimeException("Parameter " + i + " on " + testMethod.getName() + " has Annotation. Not supported until Pax Exam 2.1");
            }
            ret[i] = params.length > paramCursor ? params[paramCursor++] : null;
        }
        return ret;
    }
}

