/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.invoker.junit.internal;

import java.lang.reflect.Method;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.ops4j.pax.exam.ProbeInvoker;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.invoker.junit.internal.ContainerTestRunnerClassRequest;
import org.ops4j.pax.exam.util.Injector;
import org.ops4j.pax.swissbox.framework.ServiceLookup;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitProbeInvoker
implements ProbeInvoker {
    private BundleContext m_ctx;
    private String m_clazz;
    private String m_method;
    private Injector m_injector;

    public JUnitProbeInvoker(String encodedInstruction, BundleContext bundleContext) {
        String[] parts = encodedInstruction.split(";");
        this.m_clazz = parts[0];
        this.m_method = parts[1];
        this.m_ctx = bundleContext;
        this.m_injector = (Injector)ServiceLookup.getService((BundleContext)this.m_ctx, Injector.class);
    }

    public void call(Object ... args) {
        Class testClass;
        try {
            testClass = this.m_ctx.getBundle().loadClass(this.m_clazz);
        }
        catch (ClassNotFoundException e) {
            throw new TestContainerException((Throwable)e);
        }
        if (!this.findAndInvoke(testClass)) {
            throw new TestContainerException(" Test " + this.m_method + " not found in test class " + testClass.getName());
        }
    }

    private boolean findAndInvoke(Class<?> testClass) {
        try {
            for (Method m : testClass.getMethods()) {
                if (!m.getName().equals(this.m_method)) continue;
                this.invokeViaJUnit(testClass, m);
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            throw new TestContainerException((Throwable)e);
        }
        return false;
    }

    private void invokeViaJUnit(Class<?> testClass, Method testMethod) throws TestContainerException {
        JUnitCore junit = new JUnitCore();
        ContainerTestRunnerClassRequest classRequest = new ContainerTestRunnerClassRequest(testClass, this.m_ctx, this.m_injector);
        Description method = Description.createTestDescription(testClass, (String)this.m_method);
        Request request = classRequest.filterWith(method);
        Result result = junit.run(request);
        List failures = result.getFailures();
        if (!failures.isEmpty()) {
            throw new TestContainerException(failures.toString(), ((Failure)failures.get(0)).getException());
        }
    }
}

