/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit;

import java.lang.reflect.Method;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.spi.PaxExamRuntime;

public class PaxExamServer
extends ExternalResource {
    private Class<?> configClass;
    private TestContainer testContainer;

    public PaxExamServer() {
    }

    public PaxExamServer(Class<?> configClass) {
        this.configClass = configClass;
    }

    public Statement apply(Statement base, Description description) {
        if (this.configClass == null) {
            this.configClass = description.getTestClass();
        }
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        Option[] options = this.getConfigurationOptions();
        ExamSystem system = PaxExamRuntime.createServerSystem((Option[])options);
        this.testContainer = PaxExamRuntime.createContainer((ExamSystem)system);
        this.testContainer.start();
    }

    protected void after() {
        this.testContainer.stop();
    }

    private Option[] getConfigurationOptions() throws Exception {
        Method m = this.getConfigurationMethod(this.configClass);
        Object configClassInstance = this.configClass.newInstance();
        Option[] options = (Option[])m.invoke(configClassInstance, new Object[0]);
        return options;
    }

    private Method getConfigurationMethod(Class<?> klass) {
        Method[] methods;
        for (Method m : methods = klass.getMethods()) {
            Configuration conf = m.getAnnotation(Configuration.class);
            if (conf == null) continue;
            return m;
        }
        throw new IllegalArgumentException(klass.getName() + " has no @Configuration method");
    }
}

