/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.ops4j.io.FileUtils;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.RelativeTimeout;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.options.TimeoutOption;
import org.ops4j.pax.exam.options.WarProbeOption;
import org.ops4j.pax.exam.options.extra.CleanCachesOption;
import org.ops4j.pax.exam.options.extra.WorkingDirectoryOption;
import org.ops4j.pax.exam.spi.intern.TestProbeBuilderImpl;
import org.ops4j.pax.exam.spi.war.WarTestProbeBuilderImpl;
import org.ops4j.store.Store;
import org.ops4j.store.intern.TemporaryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExamSystem
implements ExamSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExamSystem.class);
    private final Store<InputStream> m_store;
    private final File m_configDirectory;
    private final Option[] m_combinedOptions;
    private final Stack<ExamSystem> m_subsystems;
    private final RelativeTimeout m_timeout;
    private final Set<Class<?>> m_requestedOptionTypes = new HashSet();
    private final CleanCachesOption m_clean;
    private final File m_cache;

    public static ExamSystem create(Option[] options) throws IOException {
        LOG.info("Pax Exam System (Version: " + Info.getPaxExamVersion() + ") created.");
        return new DefaultExamSystem(options);
    }

    public ExamSystem fork(Option[] options) throws IOException {
        DefaultExamSystem sys = new DefaultExamSystem(OptionUtils.combine((Option[])this.m_combinedOptions, (Option[])options));
        this.m_subsystems.add(sys);
        return sys;
    }

    private DefaultExamSystem(Option[] options) throws IOException {
        this.m_subsystems = new Stack();
        this.m_combinedOptions = OptionUtils.expand((Option[])options);
        this.m_configDirectory = new File(System.getProperty("user.home") + "/.pax/exam/");
        this.m_configDirectory.mkdirs();
        WorkingDirectoryOption work = this.getSingleOption(WorkingDirectoryOption.class);
        this.m_cache = work != null ? this.createTemp(new File(work.getWorkingDirectory())) : this.createTemp(null);
        this.m_store = new TemporaryStore(this.m_cache, false);
        TimeoutOption timeoutOption = this.getSingleOption(TimeoutOption.class);
        this.m_timeout = timeoutOption != null ? new RelativeTimeout(timeoutOption.getTimeout()) : RelativeTimeout.TIMEOUT_DEFAULT;
        this.m_clean = this.getSingleOption(CleanCachesOption.class);
    }

    private synchronized File createTemp(File workingDirectory) throws IOException {
        if (workingDirectory == null) {
            return Files.createTempDir();
        }
        workingDirectory.mkdirs();
        return workingDirectory;
    }

    public <T extends Option> T getSingleOption(Class<T> optionType) {
        this.m_requestedOptionTypes.add(optionType);
        Option[] filter = OptionUtils.filter(optionType, (Option[])this.m_combinedOptions);
        if (filter.length > 0) {
            return (T)filter[filter.length - 1];
        }
        return null;
    }

    public <T extends Option> T[] getOptions(Class<T> optionType) {
        this.m_requestedOptionTypes.add(optionType);
        return OptionUtils.filter(optionType, (Option[])this.m_combinedOptions);
    }

    public File getConfigFolder() {
        return this.m_configDirectory;
    }

    public File getTempFolder() {
        return this.m_cache;
    }

    public RelativeTimeout getTimeout() {
        return this.m_timeout;
    }

    public void clear() {
        try {
            this.warnUnusedOptions();
            if (this.m_clean == null || this.m_clean.getValue() == Boolean.TRUE) {
                for (ExamSystem sys : this.m_subsystems) {
                    sys.clear();
                }
                FileUtils.delete((File)this.m_cache.getCanonicalFile());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void warnUnusedOptions() {
        if (this.m_subsystems.isEmpty()) {
            for (String skipped : this.findOptionTypes()) {
                LOG.warn("Option " + skipped + " has not been recognized.");
            }
        }
    }

    private Set<String> findOptionTypes() {
        HashSet<String> missing = new HashSet<String>();
        for (Option option : this.m_combinedOptions) {
            boolean found = false;
            for (Class<?> c : this.m_requestedOptionTypes) {
                try {
                    option.getClass().asSubclass(c);
                    found = true;
                    break;
                }
                catch (Exception e) {
                }
            }
            if (found) continue;
            missing.add(option.getClass().getCanonicalName());
        }
        return missing;
    }

    public TestProbeBuilder createProbe() throws IOException {
        WarProbeOption warProbeOption = this.getSingleOption(WarProbeOption.class);
        if (warProbeOption == null) {
            LOG.debug("creating default probe");
            TestProbeBuilderImpl testProbeBuilder = new TestProbeBuilderImpl(this.m_store);
            testProbeBuilder.setHeader("Bundle-SymbolicName", "PAXEXAM-PROBE-" + this.createID("created probe"));
            return testProbeBuilder;
        }
        LOG.debug("creating WAR probe");
        return new WarTestProbeBuilderImpl();
    }

    public String createID(String purposeText) {
        return UUID.randomUUID().toString();
    }

    public String toString() {
        return "ExamSystem:options=" + this.m_combinedOptions.length + ";queried=" + this.m_requestedOptionTypes.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_combinedOptions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultExamSystem other = (DefaultExamSystem)obj;
        return Arrays.equals(this.m_combinedOptions, other.m_combinedOptions);
    }
}

