/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.reactors;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.intern.DefaultTestAddress;

public class AllConfinedStagedReactor
implements StagedExamReactor {
    private final List<TestProbeBuilder> m_probes;
    private final Map<TestAddress, TestContainer> m_map;

    public AllConfinedStagedReactor(List<TestContainer> containers, List<TestProbeBuilder> mProbes) {
        this.m_probes = mProbes;
        this.m_map = new LinkedHashMap<TestAddress, TestContainer>();
        int index = 0;
        for (TestContainer container : containers) {
            String caption = this.buildCaption(containers, container, index);
            for (TestProbeBuilder builder : this.m_probes) {
                for (TestAddress a : builder.getTests()) {
                    this.m_map.put(new DefaultTestAddress(a, caption, new Object[0]), container);
                }
            }
            ++index;
        }
    }

    private String buildCaption(List<TestContainer> containers, TestContainer container, int index) {
        if (containers.size() == 1) {
            return container.toString();
        }
        return String.format("%s[%d]", container.toString(), index);
    }

    public void setUp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(TestAddress address) throws Exception {
        assert (address != null) : "TestAddress must not be null.";
        TestContainer container = this.m_map.get(address);
        if (container == null) {
            throw new IllegalArgumentException("TestAddress " + address + " not from this reactor? Got it from getTargets() really?");
        }
        container.start();
        try {
            for (TestProbeBuilder builder : this.m_probes) {
                container.install(builder.build().getStream());
            }
            container.call(address);
        }
        finally {
            container.stop();
        }
    }

    @Override
    public Set<TestAddress> getTargets() {
        return this.m_map.keySet();
    }

    public void tearDown() {
    }

    @Override
    public void afterSuite() {
    }

    public void afterTest() {
    }

    public void beforeTest() {
    }

    @Override
    public void afterClass() {
    }

    @Override
    public void beforeClass() {
    }

    @Override
    public void beforeSuite() {
    }
}

