/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.reactors;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.intern.DefaultTestAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagerSingleStagedReactor
implements StagedExamReactor {
    private static Logger LOG = LoggerFactory.getLogger(EagerSingleStagedReactor.class);
    private final List<TestContainer> m_targetContainer;
    private final List<TestProbeBuilder> m_probes;
    private final Map<TestAddress, TestContainer> m_map = new LinkedHashMap<TestAddress, TestContainer>();

    public EagerSingleStagedReactor(List<TestContainer> containers, List<TestProbeBuilder> mProbes) {
        this.m_targetContainer = containers;
        this.m_probes = mProbes;
        int index = 0;
        for (TestContainer container : containers) {
            String caption = this.buildCaption(containers, container, index);
            for (TestProbeBuilder builder : mProbes) {
                for (TestAddress a : builder.getTests()) {
                    this.m_map.put(new DefaultTestAddress(a, caption, new Object[0]), container);
                }
            }
            ++index;
        }
    }

    private String buildCaption(List<TestContainer> containers, TestContainer container, int index) {
        if (containers.size() == 1) {
            return container.toString();
        }
        return String.format("%s[%d]", container.toString(), index);
    }

    public void setUp() {
        for (TestContainer container : this.m_targetContainer) {
            container.start();
            for (TestProbeBuilder builder : this.m_probes) {
                LOG.debug("installing probe " + builder);
                try {
                    container.install(builder.build().getStream());
                }
                catch (IOException e) {
                    throw new TestContainerException("Unable to build the probe.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void invoke(TestAddress address) throws Exception {
        assert (address != null) : "TestAddress must not be null.";
        TestContainer testContainer = this.m_map.get(address);
        if (testContainer == null) {
            throw new IllegalArgumentException("TestAddress " + address + " not from this reactor? Got it from getTargets() really?");
        }
        testContainer.call(address);
    }

    @Override
    public Set<TestAddress> getTargets() {
        return this.m_map.keySet();
    }

    public void tearDown() {
        for (TestContainer container : this.m_targetContainer) {
            container.stop();
        }
    }

    @Override
    public void afterSuite() {
    }

    public void afterTest() {
    }

    public void beforeTest() {
    }

    @Override
    public void afterClass() {
        this.tearDown();
    }

    @Override
    public void beforeClass() {
        this.setUp();
    }

    @Override
    public void beforeSuite() {
    }
}

