/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.war;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.UUID;
import org.ops4j.io.StreamUtils;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.options.JarProbeOption;
import org.ops4j.pax.exam.spi.war.ZipBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JarBuilder.class);
    private File tempDir;
    private JarProbeOption option;

    public JarBuilder(File tempDir, JarProbeOption option) {
        this.option = option;
        this.tempDir = tempDir;
    }

    public URI buildJar() {
        if (this.option.getName() == null) {
            this.option.name(UUID.randomUUID().toString());
        }
        try {
            File explodedJarDir = this.getExplodedJarDir();
            File probeJar = new File(this.tempDir, this.option.getName() + ".jar");
            ZipBuilder builder = new ZipBuilder(probeJar);
            builder.addDirectory(explodedJarDir, "");
            builder.close();
            URI warUri = probeJar.toURI();
            LOG.info("JAR probe = {}", (Object)warUri);
            return warUri;
        }
        catch (IOException exc) {
            throw new TestContainerException((Throwable)exc);
        }
    }

    private File getExplodedJarDir() throws IOException {
        File jarDir = new File(this.tempDir, "jar");
        LOG.debug("building webapp in {}", (Object)jarDir);
        jarDir.mkdir();
        File metaInfDir = new File(jarDir, "META-INF");
        metaInfDir.mkdir();
        for (String metaInfResource : this.option.getMetaInfResources()) {
            File source = new File(metaInfResource);
            if (source.isDirectory()) {
                this.copyDirectory(source, metaInfDir);
                continue;
            }
            Files.copy((File)source, (File)new File(metaInfDir, source.getName()));
        }
        File resourceDir = jarDir;
        resourceDir.mkdir();
        for (Class klass : this.option.getClasses()) {
            this.addClass(klass, resourceDir);
        }
        for (String resource : this.option.getResources()) {
            this.addResource(resource, resourceDir);
        }
        return jarDir;
    }

    private void addClass(Class<?> klass, File resourceDir) throws IOException {
        String resource = "/" + klass.getName().replaceAll("\\.", "/") + ".class";
        this.addResource(resource, resourceDir);
        for (Class<?> innerClass : klass.getClasses()) {
            this.addClass(innerClass, resourceDir);
        }
    }

    private void addResource(String resource, File resourceDir) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/" + resource);
        File target = new File(resourceDir, resource);
        target.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(target);
        StreamUtils.copyStream((InputStream)is, (OutputStream)os, (boolean)true);
    }

    private void copyDirectory(File fromDir, File toDir) throws IOException {
        for (File file : fromDir.listFiles()) {
            if (file.isDirectory()) {
                File targetDir = new File(toDir, file.getName());
                targetDir.mkdir();
                this.copyDirectory(file, targetDir);
                continue;
            }
            Files.copy((File)file, (File)new File(toDir, file.getName()));
        }
    }
}

