/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.war;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.ops4j.io.StreamUtils;

public class ZipBuilder {
    private FileOutputStream os;
    private ZipOutputStream jarOutputStream;

    public ZipBuilder(File zipFile) throws IOException {
        this.os = new FileOutputStream(zipFile);
        this.jarOutputStream = new ZipOutputStream(this.os);
    }

    public ZipBuilder addDirectory(File sourceDir, String targetDir) throws IOException {
        this.addDirectory(sourceDir, sourceDir, targetDir, this.jarOutputStream);
        return this;
    }

    public ZipBuilder addFile(File sourceFile, String targetFile) throws IOException {
        FileInputStream fis = new FileInputStream(sourceFile);
        ZipEntry jarEntry = new ZipEntry(targetFile);
        this.jarOutputStream.putNextEntry(jarEntry);
        StreamUtils.copyStream((InputStream)fis, (OutputStream)this.jarOutputStream, (boolean)false);
        fis.close();
        return this;
    }

    public void close() throws IOException {
        if (this.jarOutputStream != null) {
            this.jarOutputStream.close();
        } else if (this.os != null) {
            this.os.close();
        }
    }

    private void addDirectory(File root, File directory, String targetPath, ZipOutputStream zos) throws IOException {
        File[] children;
        Object prefix = targetPath;
        if (!((String)prefix).isEmpty() && !((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        if (!directory.equals(root)) {
            String path = this.normalizePath(root, directory);
            ZipEntry jarEntry = new ZipEntry((String)prefix + path + "/");
            this.jarOutputStream.putNextEntry(jarEntry);
        }
        for (File child : children = directory.listFiles()) {
            if (child.isDirectory()) {
                this.addDirectory(root, child, (String)prefix, this.jarOutputStream);
                continue;
            }
            this.addFile(root, child, (String)prefix, this.jarOutputStream);
        }
    }

    private void addFile(File root, File file, String prefix, ZipOutputStream zos) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ZipEntry jarEntry = new ZipEntry(prefix + this.normalizePath(root, file));
        zos.putNextEntry(jarEntry);
        StreamUtils.copyStream((InputStream)fis, (OutputStream)zos, (boolean)false);
        fis.close();
    }

    private String normalizePath(File root, File file) {
        String relativePath = file.getPath().substring(root.getPath().length() + 1);
        String path = relativePath.replaceAll("\\" + File.separator, "/");
        return path;
    }
}

