/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.RawUrlReference;
import org.ops4j.pax.exam.options.UrlReference;

public class BootClasspathLibraryOption
implements Option {
    private final UrlReference m_libraryUrl;
    private boolean m_append;

    public BootClasspathLibraryOption(String libraryUrl) {
        this(new RawUrlReference(libraryUrl));
    }

    public BootClasspathLibraryOption(UrlReference libraryUrl) {
        NullArgumentException.validateNotNull((Object)libraryUrl, (String)"URL");
        this.m_libraryUrl = libraryUrl;
        this.m_append = true;
    }

    public BootClasspathLibraryOption beforeFramework() {
        this.m_append = false;
        return this.itself();
    }

    public BootClasspathLibraryOption afterFramework() {
        this.m_append = true;
        return this.itself();
    }

    public UrlReference getLibraryUrl() {
        return this.m_libraryUrl;
    }

    public boolean isBeforeFramework() {
        return !this.m_append;
    }

    public boolean isAfterFramework() {
        return this.m_append;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BootClasspathOption");
        sb.append("{url=").append(this.m_libraryUrl);
        sb.append(", append=").append(this.m_append);
        sb.append('}');
        return sb.toString();
    }

    protected BootClasspathLibraryOption itself() {
        return this;
    }
}

