/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.UrlReference;

public class WarProbeOption
implements Option {
    public static final String[] DEFAULT_CLASS_PATH_EXCLUDES = new String[]{".cp", "bndlib", "jakarta.inject-api", "geronimo-ejb_", "geronimo-jcdi_", "geronimo-jpa_", "glassfish-embedded-", "hk2-api-", "javaee-api-", "jakartaee-api", "jboss-log-", "jersey-client-", "jersey-common-", "jstl-", "myfaces-", "openejb-", "org.eclipse.osgi", "pax-exam-container-", "pax-url-aether-", "resteasy-client-", "resteasy-", "scattered-archive-api-", "servlet-api-", "simple-glassfish-api-", "sisu-", "tinybundles-", "tomcat-"};
    private List<String> overlays = new ArrayList<String>();
    private List<String> libraries = new ArrayList<String>();
    private List<String> resources;
    private List<Class<?>> classes = new ArrayList();
    private List<String> metaInfResources;
    private List<String> webInfResources;
    private List<String> classpathFilters;
    private boolean useClasspath;
    private String name;

    public WarProbeOption() {
        this.resources = new ArrayList<String>();
        this.metaInfResources = new ArrayList<String>();
        this.webInfResources = new ArrayList<String>();
        this.classpathFilters = new ArrayList<String>();
    }

    public WarProbeOption name(String _name) {
        this.name = _name;
        return this;
    }

    public WarProbeOption library(String libraryPath) {
        this.libraries.add(new File(libraryPath).toURI().toString());
        return this;
    }

    public WarProbeOption library(UrlReference libraryUrl) {
        this.libraries.add(libraryUrl.getURL());
        return this;
    }

    public WarProbeOption overlay(String overlayPath) {
        this.overlays.add(new File(overlayPath).toURI().toString());
        return this;
    }

    public WarProbeOption overlay(UrlReference overlayUrl) {
        this.overlays.add(overlayUrl.getURL());
        return this;
    }

    public WarProbeOption classes(Class<?> ... klass) {
        for (Class<?> c : klass) {
            String resource = c.getName().replaceAll("\\.", "/") + ".class";
            this.resources.add(resource);
        }
        return this;
    }

    public WarProbeOption resources(String ... resourcePaths) {
        for (String resource : resourcePaths) {
            this.resources.add(resource);
        }
        return this;
    }

    public WarProbeOption metaInfResource(String resourcePath) {
        this.metaInfResources.add(resourcePath);
        return this;
    }

    public WarProbeOption webInfResource(String resourcePath) {
        this.webInfResources.add(resourcePath);
        return this;
    }

    public WarProbeOption autoClasspath(boolean includeDefaultFilters) {
        this.useClasspath = true;
        if (includeDefaultFilters) {
            for (String filter : DEFAULT_CLASS_PATH_EXCLUDES) {
                this.classpathFilters.add(filter);
            }
        }
        return this;
    }

    public WarProbeOption classPathDefaultExcludes() {
        this.useClasspath = true;
        return this.autoClasspath(true);
    }

    public WarProbeOption exclude(String ... excludeRegExp) {
        this.useClasspath = true;
        for (String exclude : excludeRegExp) {
            this.classpathFilters.add(exclude);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClassPathEnabled() {
        return this.useClasspath;
    }

    public List<String> getLibraries() {
        return this.libraries;
    }

    public List<String> getOverlays() {
        return this.overlays;
    }

    public List<String> getClassPathFilters() {
        return this.classpathFilters;
    }

    public List<String> getMetaInfResources() {
        return this.metaInfResources;
    }

    public List<String> getWebInfResources() {
        return this.webInfResources;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }
}

