/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.hsqldb.impl;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCDataSource;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.jdbc.pool.JDBCPooledDataSource;
import org.hsqldb.jdbc.pool.JDBCXADataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;

public class HsqldbDataSourceFactory
implements DataSourceFactory {
    public DataSource createDataSource(Properties props) throws SQLException {
        JDBCDataSource ds = new JDBCDataSource();
        this.setProperties((JDBCCommonDataSource)ds, props);
        return ds;
    }

    private void setProperties(JDBCCommonDataSource ds, Properties properties) throws SQLException {
        Properties props = (Properties)properties.clone();
        String databaseName = (String)props.remove("databaseName");
        String url = (String)props.remove("url");
        if (databaseName != null) {
            ds.setDatabaseName(databaseName);
        } else if (url != null) {
            ds.setUrl(url);
        } else {
            throw new SQLException("missing required property databaseName");
        }
        if (props.containsKey("password")) {
            String password = (String)props.remove("password");
            ds.setPassword(password);
        }
        if (props.containsKey("user")) {
            String user = (String)props.remove("user");
            ds.setUser(user);
        }
        if (!props.isEmpty()) {
            BeanConfig.configure((Object)ds, props);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        JDBCPooledDataSource ds = new JDBCPooledDataSource();
        this.setProperties((JDBCCommonDataSource)ds, props);
        return ds;
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        JDBCXADataSource ds = new JDBCXADataSource();
        this.setProperties((JDBCCommonDataSource)ds, props);
        return ds;
    }

    public Driver createDriver(Properties props) throws SQLException {
        JDBCDriver driver = new JDBCDriver();
        return driver;
    }
}

