/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.common;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BeanConfig {
    private final Object bean;
    private final Map<String, Method> setters;

    private BeanConfig(Object bean) {
        this.bean = bean;
        this.setters = BeanConfig.findSettersForBean(bean);
    }

    private static Map<String, Method> findSettersForBean(Object bean) {
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : bean.getClass().getMethods()) {
            String name = method.getName();
            if (!name.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String key1 = name.substring(3, 4).toLowerCase() + name.substring(4);
            String key2 = name.substring(3, 4) + name.substring(4);
            setters.put(key1, method);
            setters.put(key2, method);
        }
        return setters;
    }

    public static void configure(Object bean, Properties props) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            map.put(key, props.getProperty(key));
        }
        BeanConfig.configure(bean, map);
    }

    public static void configure(Object bean, Map<String, String> props) {
        BeanConfig beanConfig = new BeanConfig(bean);
        for (String key : props.keySet()) {
            beanConfig.trySetProperty(key, props.get(key));
        }
    }

    private void trySetProperty(String key, String value) {
        try {
            Method method = this.setters.get(key);
            if (method == null) {
                throw new IllegalArgumentException("No setter in " + this.bean.getClass() + " for property " + key);
            }
            Class<?> paramClass = method.getParameterTypes()[0];
            if (paramClass == Integer.TYPE || paramClass == Integer.class) {
                method.invoke(this.bean, Integer.parseInt(value));
            } else if (paramClass == Long.TYPE || paramClass == Long.class) {
                method.invoke(this.bean, Long.parseLong(value));
            } else if (paramClass == Boolean.TYPE || paramClass == Boolean.class) {
                method.invoke(this.bean, Boolean.parseBoolean(value));
            } else if (paramClass == Duration.class) {
                method.invoke(this.bean, Duration.ofSeconds(Long.parseLong(value)));
            } else if (paramClass == String.class) {
                method.invoke(this.bean, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error setting property " + key + ":" + e.getMessage(), e);
        }
    }
}

