/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction.jdbc.internal;

import java.util.Hashtable;
import java.util.Map;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.aries.transaction.AriesTransactionManager;
import org.apache.aries.transaction.jdbc.RecoverableDataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ManagedDataSourceFactory {
    private final ServiceReference reference;
    private final AriesTransactionManager transactionManager;
    private final CommonDataSource dataSource;
    private final Map<String, Object> properties;
    private ServiceRegistration<DataSource> registration;
    private RecoverableDataSource ds;

    public ManagedDataSourceFactory(ServiceReference reference, AriesTransactionManager transactionManager) {
        this.reference = reference;
        this.transactionManager = transactionManager;
        this.properties = new Hashtable<String, Object>();
        for (String key : reference.getPropertyKeys()) {
            this.properties.put(key, reference.getProperty(key));
        }
        this.dataSource = (CommonDataSource)reference.getBundle().getBundleContext().getService(reference);
    }

    public AriesTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public CommonDataSource getDataSource() {
        return this.dataSource;
    }

    public String getResourceName() {
        return this.getString("aries.xa.name", null);
    }

    private String getString(String name, String def) {
        Object v = this.properties.get(name);
        if (v instanceof String) {
            return (String)v;
        }
        return def;
    }

    private int getInt(String name, int def) {
        Object v = this.properties.get(name);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        return def;
    }

    private boolean getBool(String name, boolean def) {
        Object v = this.properties.get(name);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return Boolean.parseBoolean((String)v);
        }
        return def;
    }

    public void register() throws Exception {
        boolean isXaDataSource = this.dataSource instanceof XADataSource;
        Hashtable<String, Object> props = new Hashtable<String, Object>(this.properties);
        props.put("aries.managed", "true");
        if (isXaDataSource) {
            props.put("aries.xa.aware", "true");
        }
        props.put("jmx.objectname", "org.apache.aries.transaction:type=jdbc,name=" + this.getResourceName());
        props.put("service.ranking", this.getInt("service.ranking", 0) + 1000);
        this.ds = new RecoverableDataSource();
        this.ds.setDataSource(this.dataSource);
        this.ds.setExceptionSorter(this.getString("aries.xa.exceptionSorter", "all"));
        this.ds.setUsername(this.getString("aries.xa.username", null));
        this.ds.setPassword(this.getString("aries.xa.password", null));
        this.ds.setTransactionManager(this.transactionManager);
        this.ds.setAllConnectionsEquals(this.getBool("aries.xa.allConnectionsEquals", true));
        this.ds.setConnectionMaxIdleMinutes(this.getInt("aries.xa.connectionMadIdleMinutes", 15));
        this.ds.setConnectionMaxWaitMilliseconds(this.getInt("aries.xa.connectionMaxWaitMilliseconds", 5000));
        this.ds.setPartitionStrategy(this.getString("aries.xa.partitionStrategy", null));
        this.ds.setPooling(this.getBool("aries.xa.pooling", true));
        this.ds.setPoolMaxSize(this.getInt("aries.xa.poolMaxSize", 10));
        this.ds.setPoolMinSize(this.getInt("aries.xa.poolMinSize", 0));
        this.ds.setValidateOnMatch(this.getBool("aries.xa.validateOnMatch", true));
        this.ds.setBackgroundValidation(this.getBool("aries.xa.backgroundValidation", false));
        this.ds.setBackgroundValidationMilliseconds(this.getInt("aries.xa.backgroundValidationMilliseconds", 600000));
        this.ds.setTransaction(this.getString("aries.xa.transaction", isXaDataSource ? "xa" : "local"));
        this.ds.setName(this.getResourceName());
        this.ds.start();
        BundleContext context = this.reference.getBundle().getBundleContext();
        this.registration = context.registerService(DataSource.class, (Object)this.ds, props);
    }

    public void unregister() throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if (this.ds != null) {
            this.ds.stop();
        }
    }
}

