/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.c3p0.impl.ds;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C3p0PooledDataSourceFactory
implements PooledDataSourceFactory {
    protected static final String POOL_PREFIX = "c3p0.";
    private static final Logger LOG = LoggerFactory.getLogger(C3p0PooledDataSourceFactory.class);

    protected Properties getNonPoolProps(Properties props) {
        Properties dsProps = new Properties();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (key.startsWith(POOL_PREFIX)) continue;
            dsProps.put(key, props.get(key));
        }
        return dsProps;
    }

    protected final void closeDataSource(Properties props) throws SQLException {
        String dataSourceName = props.getProperty("c3p0.dataSourceName");
        if (dataSourceName != null) {
            PooledDataSource pds = C3P0Registry.pooledDataSourceByName((String)dataSourceName);
            if (pds != null) {
                LOG.info("Closing C3P0 pooled data source {}.", (Object)pds.getDataSourceName());
                pds.close();
            }
        } else {
            LOG.error("Please define c3p0.dataSourceName in your configuration to prevent memory leaks");
        }
    }

    public DataSource create(DataSourceFactory dsf, Properties config) throws SQLException {
        try {
            this.closeDataSource(config);
            DataSource unpooledDataSource = dsf.createDataSource(this.getNonPoolProps(config));
            return DataSources.pooledDataSource((DataSource)unpooledDataSource, (Properties)config);
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled datasource" + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

