/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.c3p0.impl.ds;

import com.mchange.v2.c3p0.DataSources;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.ops4j.pax.jdbc.pool.c3p0.impl.ds.C3p0PooledDataSourceFactory;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C3p0XAPooledDataSourceFactory
extends C3p0PooledDataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(C3p0XAPooledDataSourceFactory.class);
    protected TransactionManager tm;

    public C3p0XAPooledDataSourceFactory(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public DataSource create(DataSourceFactory dsf, Properties config) throws SQLException {
        try {
            this.closeDataSource(config);
            XADataSource unpooledDataSource = dsf.createXADataSource(this.getNonPoolProps(config));
            return DataSources.pooledDataSource((DataSource)((DataSource)((Object)unpooledDataSource)), (Properties)config);
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled datasource" + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

