/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.narayana.impl;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbcpPooledDataSourceFactory
implements PooledDataSourceFactory {
    protected static final String POOL_PREFIX = "pool.";
    protected static final String FACTORY_PREFIX = "factory.";
    protected static final String INITIAL_SIZE = "initialSize";
    private static final Logger LOG = LoggerFactory.getLogger(DbcpPooledDataSourceFactory.class);

    protected Map<String, String> getPoolProps(Properties props) {
        String dsName;
        Map<String, String> poolProps = this.getPrefixed(props, POOL_PREFIX);
        if (poolProps.get("jmxNameBase") == null) {
            poolProps.put("jmxNameBase", "org.ops4j.pax.jdbc.pool.dbcp2:type=GenericObjectPool,name=");
        }
        if ((dsName = (String)props.get("dataSourceName")) != null) {
            poolProps.put("jmxNamePrefix", dsName);
        }
        return poolProps;
    }

    protected Properties getNonPoolProps(Properties props) {
        Properties dsProps = new Properties();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (key.startsWith(POOL_PREFIX) || key.startsWith(FACTORY_PREFIX)) continue;
            dsProps.put(key, props.get(key));
        }
        dsProps.remove("dataSourceName");
        return dsProps;
    }

    protected Map<String, String> getPrefixed(Properties props, String prefix) {
        HashMap<String, String> prefixedProps = new HashMap<String, String>();
        for (Object keyO : props.keySet()) {
            String key = (String)keyO;
            if (!key.startsWith(prefix)) continue;
            String strippedKey = key.substring(prefix.length());
            prefixedProps.put(strippedKey, (String)props.get(key));
        }
        return prefixedProps;
    }

    protected ObjectName getJmxName(String dsName) {
        if (dsName == null) {
            dsName = UUID.randomUUID().toString();
        }
        try {
            return new ObjectName("org.ops4j.pax.jdbc.pool", "dsName", dsName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name for data source" + dsName, e);
        }
    }

    public DataSource create(DataSourceFactory dsf, Properties props) throws SQLException {
        try {
            DataSource ds = dsf.createDataSource(this.getNonPoolProps(props));
            DataSourceConnectionFactory connFactory = new DataSourceConnectionFactory(ds);
            PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
            GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
            Map<String, String> poolProps = this.getPoolProps(props);
            String initialSize = poolProps.get(INITIAL_SIZE);
            poolProps.remove(INITIAL_SIZE);
            BeanConfig.configure((Object)conf, poolProps);
            BeanConfig.configure((Object)pcf, this.getPrefixed(props, FACTORY_PREFIX));
            GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pcf, conf);
            pcf.setPool((ObjectPool)pool);
            PoolingDataSource pds = new PoolingDataSource((ObjectPool)pool);
            int size = initialSize == null ? 0 : Integer.parseInt(initialSize);
            for (int i = 0; i < size; ++i) {
                pool.addObject();
            }
            return pds;
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled datasource: " + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

