/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.transx.impl;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.TransactionSupport;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.ops4j.pax.jdbc.pool.transx.impl.TransxPooledDataSourceFactory;
import org.ops4j.pax.transx.jdbc.ManagedDataSourceBuilder;
import org.ops4j.pax.transx.tm.TransactionManager;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransxXaPooledDataSourceFactory
extends TransxPooledDataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TransxXaPooledDataSourceFactory.class);
    private final TransactionManager tm;

    public TransxXaPooledDataSourceFactory(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public DataSource create(DataSourceFactory dsf, Properties props) throws SQLException {
        try {
            TransactionSupport.TransactionSupportLevel tsl;
            CommonDataSource ds;
            Map<String, Object> poolProps = this.getPoolProps(props);
            Object local = poolProps.remove("local");
            if ("true".equals(local)) {
                ds = dsf.createDataSource(this.getNonPoolProps(props));
                tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
            } else {
                ds = dsf.createXADataSource(this.getNonPoolProps(props));
                tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
            }
            DataSource mds = ManagedDataSourceBuilder.builder().dataSource(ds).transaction(tsl).transactionManager(this.tm).properties(poolProps).build();
            return mds;
        }
        catch (Throwable e) {
            LOG.error("Error creating pooled datasource" + e.getMessage(), e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

