/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.routing.PurgePolicy;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.Scheduled;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="IdlePurgePolicy", category="Core", printObject=true)
@Scheduled
public class IdlePurgePolicy
extends AbstractLifeCycle
implements PurgePolicy,
Runnable {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final long timeToLive;
    private final ConcurrentMap<String, Long> appendersUsage = new ConcurrentHashMap<String, Long>();
    private RoutingAppender routingAppender;
    private final ConfigurationScheduler scheduler;
    private volatile ScheduledFuture<?> future = null;

    public IdlePurgePolicy(long timeToLive, ConfigurationScheduler scheduler) {
        this.timeToLive = timeToLive;
        this.scheduler = scheduler;
    }

    @Override
    public void initialize(RoutingAppender routingAppender) {
        this.routingAppender = routingAppender;
    }

    @Override
    public void stop() {
        super.stop();
        this.future.cancel(true);
    }

    @Override
    public void purge() {
        long createTime = System.currentTimeMillis() - this.timeToLive;
        for (Map.Entry entry : this.appendersUsage.entrySet()) {
            if ((Long)entry.getValue() >= createTime) continue;
            LOGGER.debug("Removing appender " + (String)entry.getKey());
            this.appendersUsage.remove(entry.getKey());
            this.routingAppender.deleteAppender((String)entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String key, LogEvent event) {
        long now = System.currentTimeMillis();
        this.appendersUsage.put(key, now);
        if (this.future == null) {
            IdlePurgePolicy idlePurgePolicy = this;
            synchronized (idlePurgePolicy) {
                if (this.future == null) {
                    this.scheduleNext();
                }
            }
        }
    }

    @Override
    public void run() {
        this.purge();
        this.scheduleNext();
    }

    private void scheduleNext() {
        long createTime = Long.MAX_VALUE;
        for (Map.Entry entry : this.appendersUsage.entrySet()) {
            if ((Long)entry.getValue() >= createTime) continue;
            createTime = (Long)entry.getValue();
        }
        if (createTime < Long.MAX_VALUE) {
            long interval = this.timeToLive - (System.currentTimeMillis() - createTime);
            this.future = this.scheduler.schedule(this, interval, TimeUnit.MILLISECONDS);
        }
    }

    @PluginFactory
    public static PurgePolicy createPurgePolicy(@PluginAttribute(value="timeToLive") String timeToLive, @PluginAttribute(value="timeUnit") String timeUnit, @PluginConfiguration Configuration configuration) {
        TimeUnit units;
        if (timeToLive == null) {
            LOGGER.error("A timeToLive  value is required");
            return null;
        }
        if (timeUnit == null) {
            units = TimeUnit.MINUTES;
        } else {
            try {
                units = TimeUnit.valueOf(timeUnit.toUpperCase());
            }
            catch (Exception ex) {
                LOGGER.error("Invalid time unit {}", (Object)timeUnit);
                units = TimeUnit.MINUTES;
            }
        }
        long ttl = units.toMillis(Long.parseLong(timeToLive));
        return new IdlePurgePolicy(ttl, configuration.getScheduler());
    }

    public String toString() {
        return "timeToLive=" + this.timeToLive;
    }
}

